/*
 * GebuehrenAnrechnungsTatbestand.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

/**
 * Klasse zur Anrechnung von {@link GebuehrenTatbestand}en
 *
 * @author Peter Schuster (setrok)
 * @date 27.06.2019
 *
 */
public class GebuehrenAnrechnungsTatbestand extends GebuehrenRahmenTatbestand implements Cloneable {
	private static final long serialVersionUID = 8877057970690141060L;
	public static final String ART = "Anrechnungstatbestand";

	/**
	 * Konstruktor für Marshaller
	 * 
	 */
	public GebuehrenAnrechnungsTatbestand() {
		super();
	}

	public GebuehrenAnrechnungsTatbestand(String vorschrift, String bezeichnung, double untergrenze, double obergrenze,
			double mittel, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
		super(vorschrift, bezeichnung, untergrenze, obergrenze, mittel, gebuehrenKlasse);
		setSatz(-Math.abs(super.getSatz()));
	}

	/**
	 * Der Gebührenfaktor als double, z.B. 1.0 oder 1.2. Beim
	 * {@link GebuehrenAnrechnungsTatbestand} ist der Faktor immer negativ.
	 * 
	 * @return Der Gebührenfaktor als double, z.B. 1.0 oder 1.2, hier immer negativ.
	 * 
	 * @see eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand#getSatz()
	 */
	@Override
	public double getSatz() {
		return -Math.abs(super.getSatz());
	}

	/**
	 * @param satz Der Gebührenfaktor als double, z.B. 1.0 oder 1.2, wird negativ
	 *             gesetzt.
	 * 
	 * @see eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand#setSatz(double)
	 */
	@Override
	public void setSatz(double satz) {
		super.setSatz(-Math.abs(satz));
	}

	@Override
	public String toString() {
		return String.format(
				"GebuehrenAnrechnungsTatbestand [vorschrift=%s, bezeichnung=%s, untergrenze=%s, obergrenze=%s, mittel=%s, gebuehrenKlasse=%s]",
				getVorschrift(), getBezeichnung(), getUntergrenze(), getObergrenze(), getMittel(),
				getGebuehrenKlasse());
	}

	@Override
	public GebuehrenAnrechnungsTatbestand clone() {
		return new GebuehrenAnrechnungsTatbestand(getVorschrift(), getBezeichnung(), getUntergrenze(), getObergrenze(),
				getMittel(), getGebuehrenKlasse());
	}

}
