/*
 * GebuehrenMapAdapter.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXB;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * {@link XmlAdapter} zum Einlesen eines {@link GebuehrenVerzeichnis}sses als
 * {@link Map}
 *
 * @author Peter Schuster (setrok)
 * @date 27.03.2020
 *
 */
public class GebuehrenMapAdapter extends XmlAdapter<GebuehrenWrapper, GebuehrenVerzeichnis> {

	/**
	 * Die Methode wandelt für den {@link JAXB}-Export mit einem {@link Marshaller}
	 * eine {@link GebuehrenVerzeichnis} in einen {@link GebuehrenWrapper}, vor
	 * allem die darin enthaltene {@link List} aus {@link GebuehrenTatbestand}en.
	 * 
	 * @param map das {@link GebuehrenVerzeichnis} als {@link Map} aus
	 *            {@link GebuehrenTatbestand}en.
	 * @return einen {@link GebuehrenWrapper} mit {@link List} aus
	 *         {@link GebuehrenTatbestand}en.
	 * @throws Exception wenn es einen Fehler beim Konvertieren gibt.
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
	 */
	@Override
	public GebuehrenWrapper marshal(GebuehrenVerzeichnis map) throws Exception {
		GebuehrenWrapper wrap = new GebuehrenWrapper();
		wrap.setTitle(map.getTitle());
		for (String key : map.keySet())
			wrap.getList().add(map.get(key));
		return wrap;
	}

	/**
	 * Die Methode wandelt für den {@link JAXB}-Import mit
	 * {@link JAXB#unmarshal(java.io.InputStream, Class)} o.ä. das
	 * {@link GebuehrenWrapper#getList()} in ein {@link GebuehrenVerzeichnis}
	 * 
	 * @param wrap eine {@link GebuehrenWrapper} mit {@link List} aus
	 *             {@link GebuehrenTatbestand}en.
	 * @return das {@link GebuehrenVerzeichnis} als {@link Map} aus
	 *         {@link GebuehrenTatbestand}en.
	 * @throws Exception wenn es einen Fehler beim Konvertieren gibt.
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
	 */
	@Override
	public GebuehrenVerzeichnis unmarshal(GebuehrenWrapper wrap) throws Exception {
		GebuehrenVerzeichnis map = new GebuehrenVerzeichnis();
		map.setTitle(wrap.getTitle());
		for (GebuehrenTatbestand gt : wrap.getList()) {
			map.put(gt.getVorschrift(), gt);
		}
		return map;
	}

}
