/*
 * GebuehrenListWrapper.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.gebuehren;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

/**
 * Wrapperklasse für das {@link GebuehrenVerzeichnis} bzw. die
 * {@link GebuehrenAuflistung}, die nur den Zweck hat, dass man die Annotations
 * nur an einer Stelle (hier) machen muss
 * 
 * Die Klasse dient dem Xml-Export einer {@link GebuehrenAuflistung} oder eines
 * {@link GebuehrenVerzeichnis}ses über eine {@link List} aus
 * {@link GebuehrenTatbestand}en. Auch der Import des
 * {@link GebuehrenVerzeichnis}ses ist gefahrlos möglich, da der Bestandteil des
 * Elements, {@link GebuehrenTatbestand#getVorschrift()}, gleichzeitig auch der
 * Key für die {@link Map} ist.
 * 
 * Die Klasse trägt die {@link XmlElement}-Annotation statt des
 * {@link GebuehrenVerzeichnis}, weil es die {@link List} eigentlich nur zum
 * {@link JAXB}-Import bzw. -Export braucht.
 *
 * @author Peter Schuster (setrok)
 * @date 26.03.2020
 *
 */
public class GebuehrenWrapper {

	private List<GebuehrenTatbestand> list;
	private String title;

	public GebuehrenWrapper() {
		super();
		setVerzeichnis(new ArrayList<GebuehrenTatbestand>());
	}

	public GebuehrenWrapper(List<GebuehrenTatbestand> verzeichnis) {
		this();
		this.getList().addAll(verzeichnis);
	}

	/**
	 * @return gibt {@link #list} als {@link List<GebuehrenTatbestand>} zurück.
	 */
	@XmlElements({ @XmlElement(name = "anrechnung", type = GebuehrenAnrechnungsTatbestand.class),
			@XmlElement(name = "wertrahmen", type = GebuehrenRahmenTatbestand.class),
			@XmlElement(name = "gebuehrenSatz", type = GebuehrenSatzTatbestand.class),
			@XmlElement(name = "mehrpauschale", type = MehrfachPauschalTatbestand.class),
			@XmlElement(name = "auslagen", type = AuslagenTatbestand.class),
			@XmlElement(name = "pauschale", type = PauschalTatbestand.class),
			@XmlElement(name = "steuer", type = MehrwertsteuerTatbestand.class),
			@XmlElement(name = "erhoehungsSatz", type = GebuehrenErhoehungsTatbestand.class) })
	public List<GebuehrenTatbestand> getList() {
		return list;
	}

	/**
	 * @param list d. {@link #list}, d. gesetzt werden soll als
	 *             {@link List<GebuehrenTatbestand>}.
	 */
	public void setVerzeichnis(List<GebuehrenTatbestand> list) {
		this.list = list;
	}

	/**
	 * @return gibt {@link #title} als {@link String} zurück.
	 */
	@XmlAttribute(name = "title")
	public String getTitle() {
		System.out.println("Title: " + title);
		return title;
	}

	/**
	 * @param title d. {@link #title}, d. gesetzt werden soll als {@link String}.
	 */
	public void setTitle(String title) {
		this.title = title;
	}
}
