package eu.gronos.kostenrechner.data.gebuehren;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;

/**
 * 
 * Zusatz-Informationen für bestimmte {@link ReduktionsGrund}e, namentlich ob
 * &sect;&nbsp;93 ZPO greift in {@link ReduktionZusatzInformation#p93} und
 * inwiefern die streitige Entscheidung begründet war in
 * {@link ReduktionZusatzInformation#begruendet}
 * 
 * @author Peter Schuster (setrok)
 * @date 03.12.2021
 *
 */
public class ReduktionZusatzInformation {
	@XmlAttribute
	public Boolean p93 = null;

	@XmlAttribute(name = "begruendetZu")
	@XmlJavaTypeAdapter(EuroAdapter.class)
	public Euro begruendet = null;
}
