package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.util.VerlusteBank;

/**
 * ein Element, man könnte sagen: Rückgabeelement, mit dem die
 * {@link NeueStreitwertReduktion} die Ergebnisse der Verarbeitung von
 * {@link StreitwertReduktionen} und {@link ReduktionStruktur} speichern kann.
 *
 * @author Peter Schuster (setrok)
 * @date 07.12.2021
 *
 */
public class ReduktionsVerarbeitung {

	/**
	 * Differenz zwischen zwei aufeinanderfolgenden Streitwerten aus
	 * {@link StreitwertReduktionen#streitwerte}
	 */
	public Euro differenz = Euro.ZERO_CENTS;

	/** Anteil der {@link #differenz} am Gesamtstreitwert */
	public Fraction anteilAmRechtsstreit = null;

	/**
	 * Hier kann die {@link NeueStreitwertReduktion}-Klasse nacheinander die
	 * {@link VerlusteBank}en ablegen
	 */
	public VerlusteBank verteilung = new VerlusteBank();
}