/*
 * BegruendungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import java.util.List;

import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

import eu.gronos.kostenrechner.interfaces.Tabulierend;

/**
 * {@link EntscheidungsElemente} für {@link TenorDatenContainer} mit den Daten
 * für {@link Tabulierend}.
 * 
 * {@link Tabulierend} sieht hier Object[][] tableCellValues vor, der von
 * Class<?>[] columnClasses und String[] columnHeaders erklärt wird. Das lässt
 * sich wohl auf XML schlecht übertragen...
 * 
 * Aber es gibt eine begrenzte Anzahl möglicher Klassen, aus denen die
 * Begründung zusammen gesetzt sein kann, nämlich String für die
 * Zeilen-/Spalten-Überschriften und Double für die Inhalte.
 */
public class BegruendungsElemente extends EntscheidungsElemente {

	/**
	 * range speichert Beginn und Ende der Begründungstabelle, also den Bereich als
	 * {@link JEditorPane#getCaret()}- / {@link Caret}-Positionen im
	 * Begründungstext, den die Tabelle ersetzen soll als {@link CaretRange}.
	 */
	@XmlElement(name = "subString")
	public CaretRange range;

	/**
	 * columnHeaders speichert, welche Spaltenüberschriften die Tabellendaten haben,
	 * als {@link List}&lt;{@link String}&gt;
	 */
	@XmlElement(name = "spaltenUeberschrift")
	@XmlElementWrapper(name = "spaltenUeberschriften")
	public List<String> columnHeaders;

	/**
	 * rowHeaders speichert die eigentlichen Tabellendaten, soweit sie
	 * {@link String}-Werte sind (Zeilenüberschriften), als
	 * {@link List}&lt;{@link String}&gt;
	 */
	@XmlElement(name = "zeilenUeberschrift")
	@XmlElementWrapper(name = "zeilenUeberschriften")
	public List<String> rowHeaders;

	/**
	 * doubleData speichert die eigentlichen Tabellendaten, soweit sie
	 * {@link Double}-Werte sind, als {@link List}&lt;{@link DoubleDataRows}
	 */
	@XmlElementWrapper(name = "zeilen")
	@XmlElement(name = "zeile")
	public List<BegruendungsZahlenZeile> zeilenZahlen;

	/**
	 * Die Methode prüft, ob die {@link BegruendungsElemente} überhaupt Daten
	 * enthalten.
	 * 
	 * @return <code>true</code>, wenn alle Bestandteile <code>null</code> oder leer
	 *         sind.
	 * 
	 * @see eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return super.isEmpty() && //
				(range == null || range.isEmpty()) && //
				(columnHeaders == null || columnHeaders.isEmpty()) && //
				(rowHeaders == null || rowHeaders.isEmpty()) && //
				(zeilenZahlen == null || zeilenZahlen.isEmpty());
	}

}