/**
 * TabulierendTableModel.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import javax.swing.table.AbstractTableModel;

import eu.gronos.kostenrechner.interfaces.Tabulierend;

/**
 * TableModel, das mit den Begründungs-Daten einer Tenoriend-erweiternden Klasse
 * gefüllt werden kann.
 *
 * @author Peter Schuster (setrok)
 * @date 12.10.2014
 *
 */
public class BegruendungsZahlenTableModel extends AbstractTableModel {

	private static final long serialVersionUID = 2019875071575074172L;
	private final Object[][] values;
	private final String[] columnNames;
	private final Class<?>[] columnClasses;

	/**
	 * Erzeugt ein TableModel, das mit den Begründungs-Daten einer
	 * Tenoriend-erweiternden Klasse gefüllt werden kann.
	 * 
	 * @param tabulierend
	 *            ein {@link Tabulierend}
	 * 
	 * @throws IllegalArgumentException
	 *             wenn das Tabulierend Arrays mit verschiedener Spaltenanzahl
	 *             zurückliefert.
	 */
	public BegruendungsZahlenTableModel(Tabulierend tabulierend)
			throws IllegalArgumentException {
		super();
		this.values = tabulierend.getTableCellValues();
		this.columnClasses = tabulierend.getColumnClasses();
		this.columnNames = tabulierend.getColumnHeaders();
		if (getColumnCount() != columnClasses.length
				|| getColumnCount() != columnNames.length)
			throw new IllegalArgumentException(
					"Spaltenanzahl inkompatibel."
							+ String.format(
									" getColumnCount(): %d, columnClasses.length: %d, columnNames.length: %d.",
									getColumnCount(), columnClasses.length,
									columnNames.length));
	}

	@Override
	public int getRowCount() {
		if (values != null)
			return values.length;
		else
			return 0;
	}

	@Override
	public int getColumnCount() {
		if (values != null && values[0].length > 0)
			return values[0].length;
		else
			return 0;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return values[rowIndex][columnIndex];
	}

	@Override
	public String getColumnName(int columnIndex) {
		return columnNames[columnIndex];
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return columnClasses[columnIndex];
	}
}
