package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;

/**
 * {@link JAXB}-{@link XmlAdapter} für den {@link BeteiligtenTyp} aus
 * {@link Beteiligter}
 */
public class BeteiligtenTypAdapter extends XmlAdapter<Integer, BeteiligtenTyp> {

	@Override
	public BeteiligtenTyp unmarshal(Integer v) throws Exception {
		if (v == null)
			return null;
		return BeteiligtenTyp.of(v);
	}

	@Override
	public Integer marshal(BeteiligtenTyp v) throws Exception {
		return v == null ? null : v.ordinal();
	}

}
