/*
 * EntscheidungsListenElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

/**
 * {@link EntscheidungsElemente} zum Tenor selbst im {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 24.03.2020
 *
 * @param <E> eine Unterklasse von {@link ProzessVerhaeltnis}, also
 *            {@link HauptsacheVerhaeltnis}, {@link KostenTragungsVerhaeltnis}
 *            oder {@link VollstreckungsVerhaeltnis}
 */
public class EntscheidungsListenElemente<E extends ProzessVerhaeltnis> extends EntscheidungsElemente {

	/**
	 * prozessverhaeltnisse speichert die strukturierte Darstellung einer
	 * Verurteilung in der Hauptsache, einer Verurteilung in den Kosten, der
	 * vorläufigen Vollstreckbarkeit einer Verurteilung als
	 * {@link List}&lt;{@link ProzessVerhaeltnis}&gt;
	 */
	@XmlElementWrapper(name = "imEinzelnen")
	@XmlElements({ @XmlElement(name = "vollstreckbar", type = VollstreckungsVerhaeltnis.class),
			@XmlElement(name = "kosten", type = KostenTragungsVerhaeltnis.class),
			@XmlElement(name = "verurteilung", type = HauptsacheVerhaeltnis.class),
			@XmlElement(name = "verhaeltnis", type = ProzessVerhaeltnis.class) })
	public List<E> prozessverhaeltnisse = new ArrayList<E>();

	/**
	 * @return <code>true</code>, wenn {@link EntscheidungsElemente#isEmpty()}
	 *         zutrifft und {@link #prozessverhaeltnisse} <code>null</code> oder
	 *         leer ist.
	 * 
	 * @see eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return super.isEmpty() && //
				((prozessverhaeltnisse == null || prozessverhaeltnisse.isEmpty()));
	}
}