package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.GenusNumerus;

/**
 * 
 * {@link JAXB}-{@link XmlAdapter} für den {@link GenusNumerus} aus
 * {@link Beteiligter}
 */
public class GenusNumerusAdapter extends XmlAdapter<Integer, Beteiligter.GenusNumerus> {

	@Override
	public GenusNumerus unmarshal(Integer v) throws Exception {
		return v == null ? null : GenusNumerus.of(v);
	}

	@Override
	public Integer marshal(GenusNumerus v) throws Exception {
		return v == null ? null : v.ordinal();
	}
}
