/**
 * KostenTragungsVerhaeltnis.java
 * eu.gronos.kostenrechner.calculation (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Klasse zum strukturierten Darstellen einer Verurteilung in den Kosten.
 *
 * @author Peter Schuster (setrok)
 * @date 27.07.2018
 *
 */
public class KostenTragungsVerhaeltnis extends ProzessVerhaeltnis {
	/**
	 * kostenAnteil speichert Bruchteil der Kostentragung (zwischen 0.0 und 1.0) als
	 * {@link Fraction} war: double.
	 */
	private Fraction kostenBruchteil;// war: doubles

	/**
	 * Konstruktor ohne Parameter.
	 * 
	 */
	public KostenTragungsVerhaeltnis() {
		super();
	}

	/**
	 * Konstruktor mit allen Feldern zur raschen Erstellung
	 * 
	 * @param glaeubiger      {@link #getGlaeubiger()}
	 * @param schuldner       {@link #getSchuldner()}
	 * @param darueberHinaus  {@link #isDarueberHinaus()}
	 * @param kostenBruchteil {@link #getKostenBruchteil()}
	 */
	public KostenTragungsVerhaeltnis(Beteiligter glaeubiger, Beteiligter schuldner, boolean darueberHinaus,
			Fraction kostenBruchteil) {
		super(glaeubiger, schuldner, darueberHinaus);
		this.kostenBruchteil = kostenBruchteil;
	}

	/**
	 * @return gibt {@link #kostenBruchteil} als double zwischen 0.0 und 1.0 zurück.
	 */ // double
	@XmlAttribute(name = "kostenBruchteil")
	@XmlJavaTypeAdapter(FractionAdapter.class)
	public Fraction getKostenBruchteil() {
		return kostenBruchteil;
	}

	/**
	 * @param kostenBruchteil d. {@link #kostenBruchteil}, d. gesetzt werden soll
	 *                        als {@link Fraction} zwischen 0 und 1/1, war: double
	 *                        zwischen 0.0 und 1.0
	 */
	public void setKostenBruchteil(Fraction kostenBruchteil) {// double
		this.kostenBruchteil = kostenBruchteil;
	}

	@Override
	public String toString() {
		return String.format("Kostentragungsverhältnis %s auf Kosten zu %s bzw. %.2f Prozent", super.toString(),
				getKostenBruchteil().toString(), getKostenBruchteil().toPercent());
		// getKostenBruchteil().doubleValue() * 100.0);
	}

}
