package eu.gronos.kostenrechner.data.tenordaten;

import java.util.Optional;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class OptionalEuroAdapter extends XmlAdapter<Double, Optional<Euro>> {

	private final EuroAdapter adapter = new EuroAdapter();

	@Override
	public Optional<Euro> unmarshal(Double v) throws Exception {
		if (v == null || v < 0.0)
			return Optional.empty();
		else
			return Optional.of(adapter.unmarshal(v));
	}

	@Override
	public Double marshal(Optional<Euro> v) throws Exception {
		if (v != null && v.isPresent())
			return adapter.marshal(v.get());
		else
			return -1.0;
	}

}
