/*
 * StreitwertEntscheidungsElemente.java
 * eu.gronos.kostenrechner.model.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.tenordaten;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * {@link EntscheidungsElemente} für den Streitwert im
 * {@link TenorDatenContainer}
 *
 * @author Peter Schuster (setrok)
 * @date 14.02.2020
 *
 */
public class StreitwertEntscheidungsElemente extends EntscheidungsElemente {

	/**
	 * streitwerte speichert einzelne Streitwerte als
	 * {@link List}&lt;{@link Euro}&gt;
	 */
	@XmlElement(name = "streitwert")
	@XmlElementWrapper(name = "streitwerte")
	@XmlJavaTypeAdapter(EuroAdapter.class)//(EuroListAdapter.class)
	public List<Euro> streitwerte = new ArrayList<>();//Long Long

	/**
	 * @return <code>true</code>, wenn {@link EntscheidungsElemente#text} und die
	 *         Streitwert-Liste beide jeweils entweder <code>null</code> oder leer
	 *         sind.
	 * 
	 * @see eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return super.isEmpty() && //
				(streitwerte == null || streitwerte.isEmpty());
	}

}