/*
 * DialogLieferant.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JDialog;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;

/**
 * Interface für {@link BeschriebeneAktion}en, die einen {@link JDialog}
 * entsprechend dem Typ-Parameter aufrufen.
 *
 * @author Peter Schuster (setrok)
 * @date 29.10.2019
 *
 * @param <E> der Typ des {@link JDialog}
 */
public interface AbfrageLieferant<E extends JDialog> {
	/**
	 * @return gibt den {@link JDialog} zurück, den die {@link BeschriebeneAktion}
	 *         erstellt, oder <code>null</code>, wenn der gerade nicht geöffnet ist.
	 */
	public E getDialog();
}
