
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.data.tenordaten.Euro;

/**
 * Ein <code>interface</code> für alle Berechnungselemente, die eine Kombination
 * aus Antrag (vulgo Inanspruchnahme, Streitwert usw) und Erfolg (vulgo
 * Verurteilung, Unterliegen usw) enthalten. Um mögliche Rundungsfehler zu
 * vermeiden, werden Euro-Beträge in <code>double</code> vermieden, stattdessen
 * ist alles in {@link Euro}.
 *
 * @author Peter Schuster (setrok)
 * @date 29.10.2021
 *
 */
public interface AntragErfolgElement {

	/**
	 * @return gibt den Wert des Antrags als {@link Euro} zurück, also den Betrag
	 *         des Antrags (vulgo Inanspruchnahme, Streitwert usw)
	 */
	Euro getAntrag();

	/**
	 * @param antrag den Wert des Antrags, d. gesetzt werden soll als {@link Euro}.
	 */
	void setAntrag(Euro antrag);

	/**
	 * @return gibt den Wert des Erfolgs des Antrags als {@link Euro} zurück, also
	 *         den Betrag des Erfolgs (vulgo Verurteilung, Unterliegen des Gegners
	 *         usw)!
	 */
	Euro getErfolg();

	/**
	 * @param erfolg den Wert des Erfolgs des Antrags, d. gesetzt werden soll als
	 *               {@link Euro}.
	 */
	void setErfolg(Euro erfolg);
}
