package eu.gronos.kostenrechner.interfaces;

/**
 * Das {@code interface} hilft einem {@link Enum} mit {@code default}-Methoden,
 * ein {@link CharSequence} zu werden. Es muss dann nur noch
 * {@link CharSequence#toString()} implementieren.
 *
 * @author Peter Schuster (setrok)
 * @date 27.11.2021
 *
 */
public interface EnumString<T extends Enum<?>> extends CharSequence {
	@Override
	public default int length() {
		return toString().length();
	}

	@Override
	public default char charAt(int index) {
		return toString().charAt(index);
	}

	@Override
	public default CharSequence subSequence(int start, int end) {
		return toString().subSequence(start, end);
	}
}