/*
 * GebuehrMitAnzahl.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;

/**
 * Da mehrere von {@link GebuehrenTatbestand} abgeleitete Klassen von einer
 * Anzahl abhängen, die aber nicht von derselben Klasse abgeleitet sind, braucht
 * es dieses interface. Die beiden benötigten Felder sind {@link #getAnzahl()}
 * und {@link #getEinheit()}.
 *
 * @author Peter Schuster (setrok)
 * @date 07.10.2019
 *
 */
public interface GebuehrenMitAnzahl {

	/**
	 * @return gibt {@link #anzahl} als {@link int} zurück, also die Anzahl der
	 *         abgegoltenen Einheiten, z.B. <code>30</code>, wenn 30km gefahren
	 *         sind.
	 */
	int getAnzahl();

	/**
	 * @param anzahl d. {@link #anzahl}, d. gesetzt werden soll als {@link int}.
	 */
	void setAnzahl(int anzahl);

	/**
	 * @return gibt {@link #einheit} als {@link String} zurück.
	 */
	String getEinheit();

	/**
	 * @param einheit d. {@link #einheit}, d. gesetzt werden soll als
	 *                {@link String}, also die Bezeichnung der Einheit, also z.B.
	 *                &quot;km&quot;
	 */
	void setEinheit(String einheit);

}