/*
 * GebuehrenMitAnzahl.java
 * eu.gronos.kostenrechner.model.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;

/**
 * Da mehrere von {@link GebuehrenTatbestand} abgeleitete Klassen von einer
 * Anzahl abhängen, die aber nicht von derselben Klasse abgeleitet sind, braucht
 * es dieses interface. Diese Erweiterung sieht eine lineare Steigung vor und
 * hat deshalb auch eine Methode {@link #getJeweils()}.
 * 
 * @param E das Format des {@link #getJeweils()}, also bisher immer
 *          {@link Double} für Satz und für Euro-Beträge, könnte aber auch
 *          {@link Long} sein, wenn man Geldbeträge als solchen speichert.
 *
 * @author Peter Schuster (setrok)
 * @date 03.10.2019
 *
 */
public interface GebuehrenMitAnzahlLinear<E> extends GebuehrenMitAnzahl {

	/**
	 * @return gibt {@link #jeweils} als {@link double} zurück, also wie hoch der
	 *         Gebührensatz je zusätzlicher Einheit steigt, bzw. die Höhe der
	 *         jeweiligen Auslagen oder der streitwertunabhängigen Gebühr/Pauschale.
	 */
	public E getJeweils();

	/**
	 * @param jeweils d. {@link #jeweils}, d. gesetzt werden soll als
	 *                {@link double}.
	 */
	public void setJeweils(E jeweils);

}