/*
 * GebuehrenTableTextfieldHandler.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableModel;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Das Interface hilft einer {@link BeschriebeneAktion}, sich mit dem
 * {@link TeilklageruecknahmePanel} oder {@link GebuehrenBerechnungPanel} über
 * {@link JFormattedTextField}s und {@link GebuehrenTableModel}s auszutauschen.
 *
 * @author Peter Schuster (setrok)
 * @date 27 Apr 2019
 *
 */
public interface GebuehrenTableTextfieldHandler
		extends PanelTableModelHandler<GebuehrenTableModel>, PanelTextFieldHandler {

	/**
	 * Die Methode gibt {@link JTable#getSelectedRow()} für die {@link JTable} mit
	 * dem angegebenen <code>index</code> zurück
	 * 
	 * @param index ein Bezeichner für das {@link TableModel}, also
	 *              {@link TeilklageruecknahmePanel#TAB_VORHER} oder
	 *              {@link TeilklageruecknahmePanel#TAB_NACHHER}
	 * @return den index der ersten ausgewählten Zeile der {@link JTable} oder
	 *         <code>-1</code>, wenn die {@link JTable} <code>null</code> oder keine
	 *         Zeile ausgewählt ist.
	 * @throws IndexOutOfBoundsException wenn ein falscher <code>index</code>
	 *                                   übergeben wird.
	 */
	public int getSelectedRow(int index) throws IndexOutOfBoundsException;

}
