/*
 * Hinzufuegbar.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein Interface, das in eu.gronos.kostenrechner.model die Elemente markiert,
 * die einem {@link TableModel} hinzugefügt werden können, das
 * {@link RowHandler} implementiert. Sie müssen sich als generischer Parameter
 * für {@link RowHandler} eignen. Vielleicht später mal interessant für
 * {@link HinzufuegenDialog}.
 *
 * @author Peter Schuster (setrok)
 * @date 05.04.2020
 *
 */
public interface Hinzufuegbar {

	/**
	 * Die Methode ist eine spezielle {@link Object#toString()}-Methode für
	 * Textausgaben oder für Oberflächenelemente wie Tabellen bzw.
	 * {@link TableCellRenderer}s. Implementierende Klassen sollen hier
	 * benutzer-lesbare {@link String}-Repräsentationen aller für die Nutzerin
	 * wichtigen Werte eines Elements in zusammenhängendem Text erzeugen.
	 * 
	 * @return eine {@link String}-Repräsentation des {@link Object}s
	 */
	public String langBezeichnung();
}
