/*
 * ParsendUndBauend.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import java.awt.Component;

import javax.swing.JComponent;

import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Das Interface soll einen Controller ermöglichen, der bei einem
 * {@link HinzufuegenDialog} eingebaut werden kann. Dieser kann den Controller
 * dann erst durch {@link #leseComponents(Component...)} alle Bausteine einlesen
 * lassen, dann mit {@link #parseEingabe()} alle nötigen Werte prüfen lassen und
 * dabei Plausibilitäten checken. Dann kann er aus den Werten mit
 * {@link #getRueckgabewert()} ein {@link Object} <code>&lt;E&gt;</code>
 * zusammenbauen.
 * 
 * Die implementierende Klasse soll auch ohne einen {@link HinzufuegenDialog}
 * funktionieren, indem {@link #parseEingabe(Object)} das zu prüfende, fertig
 * gestellte Objekt übergeben wird.
 *
 * @author Peter Schuster (setrok)
 * @date 25.06.2019
 *
 */
public interface ParsendUndBauend<E> {

	/**
	 * Die Methode soll Werte aus den {@link Component}s des
	 * {@link HinzufuegenDialog}s lesen.
	 * 
	 * @param components die {@link Component}s des Dialogs als varargs
	 * @return ein ParsendUndBauend&lt;E&gt;
	 */
	public ParsendUndBauend<E> leseComponents(Component... components);

	/**
	 * Die Methode wird aufgerufen, um zu prüfen, ob alle {@link JComponent}s zur
	 * Eingabe mit gültigen Werten gefüllt sind und diese zueinander nicht im
	 * Widerspruch stehen.
	 * 
	 * @return <code>true</code>, wenn die Plausibilitäten zufrieden sind
	 */
	public boolean parseEingabe();

	/**
	 * Die Methode wird aufgerufen, um zu prüfen, ob der Rückgabewert gültige
	 * Teilwerte hat, die zueinander nicht im Widerspruch stehen.
	 * 
	 * @param rueckgabewert ein {@link Object} (E) von demselben Typ wie
	 *                      {@link #getRueckgabewert()}
	 * @return <code>true</code>, wenn die Plausibilitäten zufrieden sind
	 */
	public boolean parseEingabe(E rueckgabewert);

	/**
	 * Die Methode soll einen Rückgabewert zurückgeben, der aus den Eingabefeldern
	 * des Dialogs zusammengebaut wurde, der dann von {@link #showDialogAndAsk()} an die
	 * aufrufende Maske zurückgegeben werden kann.
	 * 
	 * @return ein <code>&lt;E&gt;</code> mit allen Werten
	 */
	public E getRueckgabewert();
}
