package eu.gronos.kostenrechner.interfaces;

import java.util.List;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;

/**
 * {@code interface} zum Kennzeichnen einer Klasse, die die Beziehung zwischen
 * einem {@link #getAngreifer()} und einem {@link #getGegner()} beschreibt.
 *
 * @author Peter Schuster (setrok)
 * @date 11.11.2021
 *
 * @param <P> der Typ, als welcher Parteien angegeben werden, z.B.
 *            {@link List}&lt;{@link Beteiligter}> oder nur {@link Beteiligter}
 */
public interface ParteiBeziehung<P> {

	/**
	 * Die Methode gibt Zugriff auf den Angreifer in der Parteibeziehung
	 * 
	 * @return gibt den Angreifer als {@code<P>} zurück
	 * 
	 */
	P getAngreifer();

	/**
	 * Die Methode setzt den Angreifer
	 * 
	 * @param angreifer der Angreifer als {@code<P>}
	 */
	void setAngreifer(P angreifer);

	/**
	 * Die Methode gibt Zugriff auf den Gegner in der Parteibeziehung
	 * 
	 * @return gibt den Gegner als {@code<P>} zurück
	 */
	P getGegner();

	/**
	 * Die Methode setzt den {@link #getGegner()}
	 * 
	 * @param gegner der Gegner als {@code<P>}
	 */
	void setGegner(P gegner);

}
