package eu.gronos.kostenrechner.interfaces;

import java.util.List;

/**
 * Ein Interface für TableModels, die intern mit ArrayList&lt;T&gt; arbeiten und
 * bei denen jedes &lt;T&gt; eine Zeile verkörpert. Definiert Methoden zur
 * Rückgabe und zum Löschen des gesamten Tabelleninhalts als ArrayList&lt;T&gt;
 * und als Array T[].
 * 
 * @author Peter Felix Schuster (setrok)
 * @date 31.07.2014
 * @param <T> der Typ, der eine Zeile verkörpert. Muss {@link Hinzufuegbar} implementieren
 */
public interface RowList<T extends Hinzufuegbar> {

	/**
	 * Die Methode dient dazu, den ganzen Tabelleninhalt zurückzugeben.
	 * 
	 * @return ein Array T[] mit allen Werten der Tabelle
	 * @see java.util.ArrayList#toArray(T[])
	 */
	abstract T[] toArray();

	/**
	 * Die Methode dient dazu, den ganzen Tabelleninhalt zurückzugeben, d.h. eine
	 * Referenz auf die ArrayList, die intern zur Speicherung dient.
	 * 
	 * @return eine ArrayList&lt;T&gt; mit allen Werten der Tabelle
	 */
	abstract List<T> getAllValues();

	/**
	 * Entfernt alle Elemente aus der dem TableModel zugrundeliegenden ArrayList.
	 * Eine implementierende Klasse muss
	 * {@link javax.swing.table.AbstractTableModel#fireTableDataChanged()
	 * fireTableDataChanged} durchführen.
	 * 
	 * @see java.util.ArrayList#clear()
	 */
	abstract void clear();

	/**
	 * Hängt alle Werte des übergebenen Arrays der zugrundeliegenden ArrayList
	 * hinzu. Eine implementierende Klasse muss
	 * {@link javax.swing.table.AbstractTableModel#fireTableDataChanged()
	 * fireTableDataChanged} durchführen.
	 * 
	 * @param values die List<T> mit den hinzuzufügenden Werten
	 * @throws NullPointerException          if the specified collection is null
	 * @throws UnsupportedOperationException falls das TableModel diese Aktion nicht
	 *                                       unterstützt.
	 * @see java.util.ArrayList#addAll(java.util.Collection)
	 */
	abstract void addAll(List<T> values) throws NullPointerException, UnsupportedOperationException;

}