/**
 * Tabulierend.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.controller.files.RtfWerkzeugKasten;
import eu.gronos.kostenrechner.data.tenordaten.CaretRange;

/**
 * Schnittstelle um Tenorierend-Klassen zu kennzeichen, die Begründungen auch
 * als Tabellendaten zurückgeben können.
 *
 * @author Peter Schuster (setrok)
 * @date 12.10.2014
 *
 */
public interface Tabulierend {

	/**
	 * Die Methode liefert die eigentlichen Tabellendaten.
	 * 
	 * @return ein Array Object[][]
	 */
	public Object[][] getTableCellValues();

	/**
	 * Die Methode sagt, welche Datentypen von {@link #getTableCellValues()}
	 * zurückgegeben werden.
	 * 
	 * @return ein Array Class&lt;?&gt;[]
	 */
	public Class<?>[] getColumnClasses();

	/**
	 * Die Methode sagt, welche Spaltenüberschriften die Tabellendaten haben.
	 * 
	 * @return ein Array String[]
	 */
	public String[] getColumnHeaders();

	/**
	 * Die Methode dient dazu, Start und Ende des Textbereichs, der durch die
	 * Tabelle ersetzt werden soll, zurückzugeben.
	 * 
	 * @return ein {@link CaretRange}, bei dem {@link CaretRange#beginn} die
	 *         Startposition und {@link CaretRange#ende} die Endposition des
	 *         Bereichs ist, der ersetzt werden soll.
	 */
	public CaretRange getRange();

	/**
	 * Die Methode soll die Summe der Zeichen in allen Zellen der gesamten mit
	 * <code>column</code> genannten Spalte zurückgeben, damit
	 * {@link RtfWerkzeugKasten} die Spalten schön verteilen kann.
	 * 
	 * @return die Zahl der Zeichen als <code>int</code>
	 */
	public int getColumnWeight(int column);

	/**
	 * Die Methode soll die Summe der Zeichen aller Zellen in der Tabelle
	 * zurückgeben, damit {@link RtfWerkzeugKasten} die Spalten schön verteilen
	 * kann.
	 * 
	 * @return die Zahl der Zeichen als <code>int</code>
	 */
	public int getTableWeight();

}
