/*
 * DatenschutzZustimmung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.kostenrechner.model;

import eu.gronos.kostenrechner.controller.system.DatenschutzNoergler;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;

/**
 * Klasse für Rückgabeobjekte des {@link DatenschutzZustimmungDialog}s, die dann
 * der {@link DatenschutzNoergler} verarbeiten kann.
 *
 * @author Peter Schuster (setrok)
 * @date 07.01.2020
 *
 */
public class DatenschutzZustimmung {

	/**
	 * emailBasisZugestimmt speichert als {@link boolean}, ob der Nutzer überhaupt
	 * dem E-Mail-Versand zugestimmt hat.
	 */
	public boolean emailBasisZugestimmt = false;
	/**
	 * OPTION_DSGVO_EMAIL_BASIS ist der Parameter als <code>int</code>, dass die
	 * Zustimmung dem E-Mail-Versand überhaupt benötigt wird.
	 */
	public static final int OPTION_DSGVO_EMAIL_BASIS = 21;

	/**
	 * emailAnhangZugestimmt speichert als {@link boolean}, ob die Nutzerin auch dem
	 * Versand von Anlagen (Exception-Stacktrace bzw.
	 * {@link VerfahrensDatenContainer}n usw.) zugestimmt hat.
	 */
	public boolean emailAnhangZugestimmt = false;
	/**
	 * OPTION_DSGVO_EMAIL_ANHANG ist der Parameter als <code>int</code>, dass die
	 * Zustimmung auch zum Versand von Anlagen (Exception-Stacktrace bzw.
	 * {@link VerfahrensDatenContainer}n usw.) benötigt wird.
	 */
	public static final int OPTION_DSGVO_EMAIL_ANHANG = 34;

	/**
	 * Die Methode dient dazu, auch automatisiert die Zustände abzufragen, also aus
	 * Methoden, die selbst nur eine der Konstanten übergeben bekommen.
	 * 
	 * @param level {@link #OPTION_DSGVO_EMAIL_BASIS} oder
	 *              {@link #OPTION_DSGVO_EMAIL_ANHANG}
	 * @return je nach Auswahl den Wert von {@link #emailBasisZugestimmt} oder
	 *         {@link #emailAnhangZugestimmt}
	 */
	public boolean get(int level) {
		if (OPTION_DSGVO_EMAIL_BASIS == level)
			return emailBasisZugestimmt;
		else if (OPTION_DSGVO_EMAIL_ANHANG == level)
			return emailAnhangZugestimmt;
		else
			throw new IllegalArgumentException("Ungültiger Parameter: " + level);
	}

	/**
	 * Die Methode setzt automatisiert die Werte von den Zuständen, also aus
	 * Methoden heraus, die selbst nur eine der Konstanten übergeben bekommen.
	 * 
	 * @param level      {@link #OPTION_DSGVO_EMAIL_BASIS} oder
	 *                   {@link #OPTION_DSGVO_EMAIL_ANHANG}
	 * @param zugestimmt ein <code>boolean</code>
	 */
	public void set(int level, boolean zugestimmt) {
		if (OPTION_DSGVO_EMAIL_BASIS == level)
			emailBasisZugestimmt = zugestimmt;
		else if (OPTION_DSGVO_EMAIL_ANHANG == level)
			emailAnhangZugestimmt = zugestimmt;
		else
			throw new IllegalArgumentException("Ungültiger Parameter: " + level);
	}
}
