/*
 * BeteiligtenListModel.java
 * eu.gronos.kostenrechner.model.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.model.baumbach;

import java.util.Collection;

import javax.swing.AbstractListModel;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;

/**
 * Ein {@link AbstractListModel} für {@link BaumbachBeteiligter}, das intern mit
 * einer {@link BaumbachBeteiligtenListe} arbeitet.
 *
 * @author Peter Schuster (setrok)
 * @date 15.07.2019
 *
 */
public class BeteiligtenListModel extends AbstractListModel<BaumbachBeteiligter> {
	private static final long serialVersionUID = 5373140824521500000L;
	private BaumbachBeteiligtenListe values;

	public BeteiligtenListModel(BaumbachBeteiligtenListe values) {
		this();
		setValues(values);
	}

	/**
	 * @see javax.swing.AbstractListModel#AbstractListModel() 
	 * 
	 */
	public BeteiligtenListModel() {
		super();
	}

	/**
	 * @see javax.swing.ListModel#getSize()
	 */
	@Override
	public int getSize() {
		return values.size();
	}

	/**
	 * @see javax.swing.ListModel#getElementAt(int)
	 */
	@Override
	public BaumbachBeteiligter getElementAt(int index) {
		return values.get(index);
	}

	public boolean addAll(Collection<? extends BaumbachBeteiligter> values) {
		final boolean b = this.values.addAll(values);
		fireContentsChanged(this, 0, getSize() - 1);
		return b;
	}

	public void setValues(BaumbachBeteiligtenListe values) {
		this.values = values;
		fireContentsChanged(this, 0, getSize() - 1);
	}

	public BaumbachBeteiligtenListe getValues() {
		return values;
	}
}
