package eu.gronos.kostenrechner.util;

import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.*;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.Pruefend;

/**
 * Ein {@link Pruefend} für {@link Beteiligter}
 *
 * @author Peter Schuster (setrok)
 * @date 25.11.2021
 *
 */
public  class EinzelBeteiligtenPruefer implements Pruefend<Beteiligter> {

    @Override
    public boolean pruefeEingabe(Beteiligter b)
            throws IllegalArgumentException, NullPointerException {
        if (b.getLfdNr() < 0)
            throw new IllegalArgumentException("Keine laufende Nummer");
//        if (b.getGenusNumerus() < MAENNLICH
//                || b.getGenusNumerus() > (WEIBLICH + PLURAL))
//            throw new IllegalArgumentException(
//                    "Ungültiger Genus/Numerus: " + b.getGenusNumerus());
        if (b.getTyp() != KLAEGER
                && b.getTyp() != DRITTWIDERBEKLAGTE
                && b.getTyp() != BEKLAGTE
                && b.getTyp() != GERICHTSKOSTEN)
            throw new IllegalArgumentException(
                    "Ungültiger Beteiligtentyp: " + b.getTyp());

        return true;
    }

}
