/*
 * ErsetzungComparator.java
 * eu.gronos.kostenrechner.data (Kostenrechner)
 */
package eu.gronos.kostenrechner.util;

import java.util.Comparator;

import eu.gronos.kostenrechner.data.Ersetzung;

/**
 * Die Klasse vergleicht die {@link Ersetzung} anhand {@link String#length()}
 * von {@link #getReplace()}, so dass das größere Elemente bei der Sortierung
 * weiter vorne steht.
 *
 * @author Peter Schuster (setrok)
 * @date 14.12.2020
 *
 */
public class ErsetzungComparator implements Comparator<Ersetzung> {

	/**
	 * Die Methode vergleicht die {@link Ersetzung} anhand {@link String#length()}
	 * von {@link #getReplace()}, so dass das größere Elemente bei der Sortierung
	 * weiter vorne stehen. Innerhalb von Begriffen gleicher Länge sortiert sie nach
	 * dem Alphabet.
	 * 
	 * @param o1 die {@link Ersetzung} zum Vergleichen
	 * @param o2 die {@link Ersetzung} zum Vergleichen
	 * @return 0, wenn beide gleich lang sind, einen negativen Wert, wenn diese
	 *         {@link Ersetzung#getReplace()} größer ist als beim Vergleichsobjekt
	 *         und ansonsten einen Wert über Null.
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 * @see java.lang.Integer#compareTo(java.lang.Integer)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compare(Ersetzung o1, Ersetzung o2) {
		final Integer int1 = new Integer(o1.getReplace().length());
		final Integer int2 = new Integer(o2.getReplace().length());
		final int result = int2.compareTo(int1);
		if (result != 0) {
			return result;
		} else {
			return o1.getReplace().compareTo(o2.getReplace());
		}
	}
}