/*
 * VollstreckbarkeitsPruefer.java
 * eu.gronos.kostenrechner.data.tenordaten (Kostenrechner)
 */
package eu.gronos.kostenrechner.util;

import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;
import eu.gronos.kostenrechner.interfaces.Pruefend;

/**
 * Eine {@link Pruefend}e Klasse für {@link Vollstreckbarkeit}
 *
 * @author Peter Schuster (setrok)
 * @date 09.08.2020
 *
 */
public class VollstreckbarkeitsPruefer implements Pruefend<Vollstreckbarkeit> {

	/**
	 * Die Methode erkennt fehlerhafte Kombinationen der einzelnen
	 * Vollstreckbarkeitsvorschriften.
	 * 
	 * @param eingabe die zu prüfende {@link Vollstreckbarkeit}-Instanz
	 * 
	 * @return <code>true</code>, wenn die gewählte Kombination gültig ist.
	 * @throws IllegalArgumentException wenn die Kombination nicht gültig ist
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Pruefend#pruefeEingabe(java.lang.Object)
	 */
	public boolean pruefeEingabe(Vollstreckbarkeit eingabe) throws IllegalArgumentException {
		if (eingabe.isB708()) {
			if (eingabe.isB711() && eingabe.isB709s2() && !eingabe.isB709s1() && !eingabe.isB713())
				/* §§ 708, 709 S. 2, 711 ZPO */
				return true;
			else if (eingabe.isB713() && !eingabe.isB709s1() && !eingabe.isB709s2() && !eingabe.isB711())
				/* §§ 708, 713 ZPO */
				return true;
		} else if (eingabe.isB709s1()) {
			/* § 709 S. 1, S. 2 ZPO */
			if (eingabe.isB709s2() && !eingabe.isB708() && !eingabe.isB713())
				return true;
		} else if (!eingabe.isB708() && !eingabe.isB709s1() && !eingabe.isB709s2() && !eingabe.isB709s2()
				&& !eingabe.isB711() && !eingabe.isB713()) {
			/*
			 * Es darf auch alles false sein, sonst könnte das erste Element der Liste nicht
			 * generiert werden
			 */
			return true;
		}
		throw new IllegalArgumentException("Ungültige Kombination von " + toString());
	}
}