/*
 * BeteiligtenPruefer.java
 * eu.gronos.kostenrechner.util.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.util.baumbach;

import static eu.gronos.kostenrechner.data.tenordaten.Euro.ZERO_CENTS;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.KLAEGER;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.EinzelBeteiligtenPruefer;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Der {@link Pruefend} kontrolliert alle Werte zum Bau eines
 * {@link Beteiligter}n
 *
 * @author Peter Schuster (setrok)
 * @date 16.07.2020
 *
 * @todo TODO muss {@link EinzelBeteiligtenPruefer} nutzen!
 */
public class BeteiligtenPruefer implements Pruefend<BaumbachBeteiligter> {

	// private final EinzelBeteiligtenPruefer ebp = new EinzelBeteiligtenPruefer();

	/**
	 * Die Methode prüft den {@link BaumbachBeteiligter}n
	 * 
	 * @param eingabe der zu prüfende {@link BaumbachBeteiligter}
	 * @return <code>true</code>, wenn alle Plausis eingehalten werden
	 * @throws IllegalArgumentException wenn ein Dwbk nicht widerbeklagt ist oder
	 *                                  ein nicht widerbeklagter Kläger einen
	 *                                  Streitwert hat.
	 * @throws NumberFormatException    wenn der Streitwert < Unterliegen oder
	 *                                  Streitwert < 0 bzw. Unterliegen < 0
	 * @throws NullPointerException     kann immer mal passieren
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Pruefend#pruefeEingabe(java.lang.Object)
	 */
	@Override
	public boolean pruefeEingabe(BaumbachBeteiligter eingabe)
			throws IllegalArgumentException, NumberFormatException, NullPointerException {
		if (eingabe.getAntrag() == null)
			throw new NullPointerException("antrag ist null bei " + eingabe.toString());
		if (eingabe.getErfolg() == null)
			throw new NullPointerException("erfolg ist null bei " + eingabe.toString());
//		if (!ebp.pruefeEingabe(eingabe))
//			throw new IllegalArgumentException("Kein gültiger Beteiligter!");
		// if (eingabe.getAntrag() < eingabe.getErfolg())
		if (eingabe.getAntrag().lessThan(eingabe.getErfolg()))
			throw new NumberFormatException(HinzufuegenDialog.FEHLER_BT_UNTERLIEGEN_GT_STREITWERT);
		// if (eingabe.getAntrag() <= 0.0 && (KLAEGER != eingabe.getTyp() ||
		// eingabe.isAnWiderklageBeteiligt()))
		if (eingabe.getAntrag().lessThanOrEqualTo(ZERO_CENTS)
				&& (KLAEGER != eingabe.getTyp() || eingabe.isAnWiderklageBeteiligt()))
			throw new IllegalArgumentException(HinzufuegenDialog.FEHLER_BK_STREITWERT);
		if (DRITTWIDERBEKLAGTE == eingabe.getTyp() && !eingabe.isAnWiderklageBeteiligt())
			throw new IllegalArgumentException("Ein Drittwiderbeklagter muss widerbeklagt sein!");
		// Ein nicht widerbeklagter Kläger mit Streitwert/Unterliegen > 0 führt zu
		// Fehlern
		if (KLAEGER == eingabe.getTyp() && !eingabe.isAnWiderklageBeteiligt()
				&& (eingabe.getAntrag().greaterThan(ZERO_CENTS) || eingabe.getErfolg().greaterThan(ZERO_CENTS)))
			// && (eingabe.getAntrag() > 0.0 || eingabe.getErfolg() > 0.0))
			throw new IllegalArgumentException(
					"Ein nicht widerbeklagter Kläger darf nicht in Anspruch genommen oder verurteilt werden (Streitwert oder Verurteilung dürfen nicht größer als 0 sein)!");
		return true;
	}

}
