package eu.gronos.kostenrechner.util.baumbach;

import java.util.Comparator;


import eu.gronos.kostenrechner.data.tenordaten.ProzessVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.TenorTyp;

public class ProzessVerhaeltnisseInTenorReihenfolge implements Comparator<ProzessVerhaeltnis> {

	/**
	 * Die Methode dient dazu, zwei Prozessverhältnisse zu vergleichen, um sie
	 * sortieren zu können. Stellt zunächst auf die Klasse (Hauptsache vor Kosten
	 * vor Vollstreckbarkeit), dann die Gläubiger, dann auf die Schuldner ab.
	 * 
	 * 
	 * @param one   das eine zu vergleichende {@link ProzessVerhaeltnis}
	 * @param other das weitere zu vergleichende {@link ProzessVerhaeltnis}
	 * @return a negative integer, zero, or a positive integer as this object is
	 *         less than, equal to, or greater than the specified object.
	 * 
	 * 
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(ProzessVerhaeltnis one, ProzessVerhaeltnis other) {
		if (one.equals(other)) {
			return 0;
		}
		if (one.getClass() != other.getClass()) {
			return (TenorTyp.of(one).compareTo(TenorTyp.of(other)));
		}
		final BeteiligteInAngreiferGegnerReihenfolge comparator = new BeteiligteInAngreiferGegnerReihenfolge();
		if (one.getGlaeubiger().equals(other.getGlaeubiger())) {
			return comparator.compare(one.getSchuldner(), other.getSchuldner());
		} else {
			return comparator.compare(one.getGlaeubiger(), other.getGlaeubiger());
		}
	}

}
