package eu.gronos.kostenrechner.util.baumbach;


import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.StreitgenossenAngriffe;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.EinzelBeteiligtenPruefer;

/**
 * Ein {@link Pruefend} für {@link StreitgenossenAngriffe}
 *
 * @author Peter Schuster (setrok)
 * @date 25.11.2021
 *
 */
public class StreitgenossenAngriffePruefer implements Pruefend<StreitgenossenAngriffe> {

	@Override
	public boolean pruefeEingabe(StreitgenossenAngriffe eingabe) throws IllegalArgumentException, NullPointerException {
		if (eingabe.isEmpty())
			throw new IllegalArgumentException("Nix da!");

		// Beteiligte prüfen
		Pruefend<Beteiligter> beteiligtenPruefer = new EinzelBeteiligtenPruefer();
		eingabe.beteiligte.forEach(beteiligtenPruefer::pruefeEingabe);

		// Angriffe prüfen
		new AngriffListePruefer().pruefeEingabe(eingabe.angriffe);

		// Prüfen, ob alle #getGegner und #getAngreifer in den Angriffen eine
		// Entsprechung in #beteiligte haben
		for (Angriff angriff : eingabe.angriffe) {
			if (!eingabe.beteiligte.containsAll(angriff.joinBeteiligte()))
				throw new IllegalArgumentException("Nicht alle Beteiligte aus den Angriffen in beteiligte!");
		}

		return true;
	}

}
