/*
 * FehlerWrapper.java
 * eu.gronos.kostenrechnertest.guitest.ausgaben (Kostenrechner Test)
 */
package eu.gronos.kostenrechner.util.files;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * Die Klasse hilft beim Xml-Export eines {@link StackTraceElement}s
 *
 * @author Peter Schuster (setrok)
 * @date 27.11.2019
 *
 */
@XmlType(propOrder = { "fileName", "className", "methodName", "lineNumber" })
public class StackTraceWrapper {

	private String fileName;
	private String className;
	private String methodName;
	private int lineNumber;

	/**
	 * @return gibt {@link #fileName} als {@link String} zurück.
	 */
	@XmlAttribute(name = "file")
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName d. {@link #fileName}, d. gesetzt werden soll als
	 *                 {@link String}.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return gibt {@link #className} als {@link String} zurück.
	 */
	@XmlAttribute(name = "class")
	public String getClassName() {
		return className;
	}

	/**
	 * @param className d. {@link #className}, d. gesetzt werden soll als
	 *                  {@link String}.
	 */
	public void setClassName(String className) {
		this.className = className;
	}

	/**
	 * @return gibt {@link #methodName} als {@link String} zurück.
	 */
	@XmlAttribute(name = "method")
	public String getMethodName() {
		return methodName;
	}

	/**
	 * @param methodName d. {@link #methodName}, d. gesetzt werden soll als
	 *                   {@link String}.
	 */
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	/**
	 * @return gibt {@link #lineNumber} als {@link int} zurück.
	 */
	@XmlAttribute(name = "line")
	public int getLineNumber() {
		return lineNumber;
	}

	/**
	 * @param lineNumber d. {@link #lineNumber}, d. gesetzt werden soll als
	 *                   {@link int}.
	 */
	public void setLineNumber(int lineNumber) {
		this.lineNumber = lineNumber;
	}

}
