/*
 * ForderungPruefer.java
 * eu.gronos.kostenrechner.controller.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.util.forderungen;

import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Der {@link Pruefend} kontrolliert alle Werte zum Bau einer {@link Forderung}
 * 
 * @author Peter Schuster (setrok)
 * @date 16.07.2020
 *
 */
public final class ForderungPruefer implements Pruefend<Forderung> {
	/**
	 * Die Methode prüft die {@link Forderung}
	 * 
	 * @param eingabe die {@link Forderung}
	 * @return <code>true</code>, wenn alle Plausis eingehalten werden
	 * @throws IllegalArgumentException wenn {@link Forderung#getErfolg()} &gt;
	 *                                  {@link Forderung#getAntrag()}
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Pruefend#pruefeEingabe(java.lang.Object)
	 */
	@Override
	public boolean pruefeEingabe(Forderung eingabe) throws IllegalArgumentException {
		//eingabe.getErfolg() > eingabe.getWert()
		if (eingabe.getErfolg().greaterThan(eingabe.getAntrag())) {
			throw new IllegalArgumentException(HinzufuegenDialog.FEHLER_BEGRUENDETHEIT_GT_WERT);
		}

		return true;
	}
}