/*
 * TeilklageruecknahmePruefer.java
 * eu.gronos.kostenrechner.util.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.util.gebuehren;

import javax.swing.JFormattedTextField;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.logic.TenorTexter;

/**
 * Ein {@link Pruefend} für eine {@link UnterContainerKlasse}
 * {@link Teilklageruecknahme}
 *
 * @author Peter Schuster (setrok)
 * @date 16.07.2020
 *
 */
public class TeilklageruecknahmePruefer implements Pruefend<Teilklageruecknahme> {

	/**
	 * Die Methode überprüft die {@link UnterContainerKlasse}, indem sie ihr
	 * übergeben wird.
	 * 
	 * @param eingabe die zu prüfende {@link UnterContainerKlasse} vom Typ
	 *                {@link Teilklageruecknahme}
	 * @return <code>true</code>, wenn die Plausibilitäten zufrieden sind
	 * @throws NumberFormatException    wenn der {@link NumberExtractor} bei einem
	 *                                  {@link JFormattedTextField} eine solche
	 *                                  Exception wirft.
	 * @throws NullPointerException     nur zur Sicherheit...
	 * @throws IllegalArgumentException wird geworfen, wenn eine der beiden
	 *                                  folgenden Plausibilitäten verletzt ist: a)
	 *                                  der frühere Streitwert muss größer als der
	 *                                  spätere (oder gleich) sein, b) der spätere
	 *                                  Streitwert muss größer als die Verurteilung
	 *                                  (oder gleich) sein.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Pruefend#pruefeEingabe(java.lang.Object)
	 */
	@Override
	public boolean pruefeEingabe(Teilklageruecknahme eingabe)
			throws IllegalArgumentException, NumberFormatException, NullPointerException {

		/* Prüfen, ob die Reihenfolge der Streitwerte eingehalten ist */
		if (eingabe.streitwerteUndObsiegen == null || eingabe.streitwerteUndObsiegen.isEmpty())
			throw new IllegalArgumentException("Keine Streitwerte angegeben!");
		if (eingabe.streitwerteUndObsiegen.get(1).greaterThan(eingabe.streitwerteUndObsiegen.get(0)))// >
			throw new IllegalArgumentException(TenorTexter.FEHLER_REIHENFOLGE_STREITWERTE);
		/* Prüfen, ob Verurteilung nicht höher als die Streitwerte ist */
		if (eingabe.streitwerteUndObsiegen.get(2).greaterThan(eingabe.streitwerteUndObsiegen.get(1)))// > 
			throw new IllegalArgumentException(TenorTexter.FEHLER_REIHENFOLGE_VERURTEILUNG);

		/* Jetzt noch die Einzelkomponenten prüfen */
		final GebuehrenPruefer pruefer = new GebuehrenPruefer();
		for (GebuehrenAuflistung verzeichnis : new GebuehrenAuflistung[] { eingabe.vorher, eingabe.nachher }) {
			for (GebuehrenTatbestand gt : verzeichnis) {
				pruefer.pruefeEingabe(gt);
			}
		}

		return true;
	}

}
