/**
 * StreitwertReduktionPanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.gebuehren;

import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.BEKLAGTE;
import static eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp.KLAEGER;

import java.awt.GridBagLayout;
import java.awt.event.FocusListener;

import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrNeuAction;
import eu.gronos.kostenrechner.controller.gebuehren.StreitwertReduktionHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTenorAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTerminAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageVerschiebenAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageruecknahmeParser;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;

/**
 * Diese von {@link KostenJPanel} abgeleitete Klasse nimmt die
 * Oberflächenelemente für die Streitwertreduktion auf.
 *
 * @author Peter Schuster (setrok)
 * @date 13.06.2018
 *
 */
public class TeilklageruecknahmePanel extends KostenJPanel
		implements WerteLesbar<Teilklageruecknahme>, GebuehrenTableTextfieldHandler {
	private static final long serialVersionUID = 1618328009895591401L;
	private static final TeilklageruecknahmePanel instance = new TeilklageruecknahmePanel();
	private Kostenrechner kostenrechner;
	JComboBox<Beteiligter> cbBeklagte;
	JComboBox<Beteiligter> cbKlaeger;
	private JFormattedTextField ftfStreitwertVorher;
	public JTable tabVorher;
	private GebuehrenTableModel gttmVorher;
	private final AbstractAction neueGebuehrVorherAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(12021), TABLE_FTF_VORHER);
	private final AbstractAction neueGebuehrNachherAction = new GebuehrNeuAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(13021), TABLE_FTF_NACHHER);

	private final BooleanConfigAction berechnungsMethodeAction = new BooleanConfigAction(
			(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(15001));

	private final AbstractAction tenorErmittelnAction = new TeilklageTenorAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(15005));
	private final AbstractAction gebuehrenTbVerschiebenAction = new TeilklageVerschiebenAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17111));
	public AbstractAction klageruecknahmeTerminAction = new TeilklageTerminAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17121));

	private JFormattedTextField ftfStreitwertNachher;
	private JFormattedTextField ftfObsiegen;

	private final FocusListener streitwertListener = new StreitwertReduktionHorcher(this);
	public JTable tabNachher;
	private GebuehrenTableModel gttmNachher;
	public static final String FEHLER_KEINE_GEBUEHREN = "Fehler: Keine Gebühren angefallen!";
	public static final String FEHLER_KEINE_GEBUEHREN_LANG = "Bitte geben Sie zunächst ein welche Gebühren vor und/oder nach der Streitwertreduktion angefallen waren.";
	public static final int TABLE_FTF_VORHER = 0;
	public static final int TABLE_FTF_NACHHER = 1;
	public static final int FTF_OBSIEGEN = 2;
	private JToggleButton btnBerechnungsMethode;
	private JLabel lblStreitwertVorReduktion;
	private JLabel lblStreitwertNachReduktion;
	private JLabel lblLetztlichObsiegt;
	private ParsendUndBauend<Teilklageruecknahme> pruefer = new TeilklageruecknahmeParser();

	/**
	 * Der Konstruktor ruft die Oberklasse auf.
	 * 
	 */
	private TeilklageruecknahmePanel() {
		super();
	}

	/**
	 * Das Panel ist als Singelton ausgestatltet. Diese Methode gibt die alleinige
	 * Instanz zurück.
	 * 
	 * @return gibt {@link #instance} als TeilklageruecknahmePanel zurück.
	 */
	public static TeilklageruecknahmePanel getInstance() {
		return instance;
	}

	/**
	 * Die Methode setzt die Oberflächenelemente für die Registerkarte 1
	 * Teilklagerücknahme
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JPanel pnParteien = super.addNewPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11000),
				new GridBagLayout());
//				super.createPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11000),
//				new GridBagLayout());

//		JLabel lblKlBezeichner = (JLabel) beschrifter.beschrifte(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(11001));
//		JLabel lblKlBezeichner = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(11001), pnParteien);

//		lblKlBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(KLAEGER, true);
		cbKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
//		beschrifter.beschrifteVergittert(
		beschrifter.beschrifteGemeinsam(new JLabel(), (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11001),
				cbKlaeger, (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11005), pnParteien);
		cbKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
//		lblKlBezeichner.setLabelFor(cbKlaeger);

//		JLabel lblBkBezeichner = (JLabel) beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(11011), pnParteien);
//		lblBkBezeichner.setHorizontalAlignment(SwingConstants.RIGHT);

		Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(BEKLAGTE, true);
		cbBeklagte = new JComboBox<Beteiligter>(bkBezeichnerListe);
		beschrifter.beschrifteGemeinsam(new JLabel(), (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11011),
				cbBeklagte, (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(11015), pnParteien);
		cbBeklagte.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
//		lblBkBezeichner.setLabelFor(cbBeklagte);

		JPanel pnVorher = super.addNewPanel((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(12000),
				new GridBagLayout());
//		lblStreitwertVorReduktion = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(12001), pnVorher);
//		lblStreitwertVorReduktion.setHorizontalAlignment(SwingConstants.RIGHT);

		// .beschrifteVergittert(
		ftfStreitwertVorher = (JFormattedTextField) beschrifter.beschrifteGemeinsam(
				lblStreitwertVorReduktion = new JLabel(), new JFormattedTextField(KostenJPanel.FORMATTER_INT),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(12005), pnVorher);
		ftfStreitwertVorher.setColumns(10);
		ftfStreitwertVorher.addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
//		ftfStreitwertVorher.setHorizontalAlignment(JTextField.RIGHT);
//		lblStreitwertVorReduktion.setLabelFor(ftfStreitwertVorher);

		// leereWerte() geht hier noch nicht, weil der auch die Textfelder braucht
		leereGebuehrenTabellen();

		tabVorher = (JTable) beschrifter.beschrifte(new JTable(getGttmVorher()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(12011));
		entferneTastaturFalle(tabVorher);
		setzeGebuehrenTabelleAussehen(tabVorher);
//		JScrollPane scpVorher = (JScrollPane) 
		beschrifter.beschrifteVergittert(new JScrollPane(tabVorher), NameContainerSammlung.BESCHRIFTUNGEN.get(12010),
				pnVorher);

//		JButton btnNeueGebhrvorher = (JButton) 
		// ((BeschriebeneAktion) neueGebuehrVorherAction).toButton();
		beschrifter.add((BeschriebeneAktion) neueGebuehrVorherAction, pnVorher);
		JPanel pnNachher = super.addNewPanel// createPanel
		((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(13000), new GridBagLayout());

//		lblStreitwertNachReduktion = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(13001), pnNachher);
//		lblStreitwertNachReduktion.setHorizontalAlignment(SwingConstants.RIGHT);

		setFtfStreitwertNachher((JFormattedTextField) beschrifter.beschrifteGemeinsam(
				lblStreitwertNachReduktion = new JLabel(), new JFormattedTextField(KostenJPanel.FORMATTER_INT),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(13005), pnNachher));
		getFtfStreitwertNachher().setColumns(10);
		getFtfStreitwertNachher().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
		getFtfStreitwertNachher().addFocusListener(streitwertListener);
//		getFtfStreitwertNachher().setHorizontalAlignment(JTextField.RIGHT);
//		lblStreitwertNachReduktion.setLabelFor(getFtfStreitwertNachher());

		tabNachher = (JTable) beschrifter.beschrifte(new JTable(getGttmNachher()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(13011));
		entferneTastaturFalle(tabNachher);
		setzeGebuehrenTabelleAussehen(tabNachher);
//		JScrollPane scpNachher = (JScrollPane) 
		beschrifter.beschrifteVergittert(new JScrollPane(tabNachher), NameContainerSammlung.BESCHRIFTUNGEN.get(13010),
				pnNachher);

//		JButton btnNeueGebhrnachher = 
//		.toButton()
		beschrifter.add((BeschriebeneAktion) neueGebuehrNachherAction, pnNachher);

		JPanel pnLetztlichObsiegt = super.addNewPanel// createPanel
		((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(14000), new GridBagLayout());
//		lblLetztlichObsiegt = (JLabel) beschrifter.beschrifteVergittert(new JLabel(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(14001), pnLetztlichObsiegt);
//		lblLetztlichObsiegt.setHorizontalAlignment(SwingConstants.RIGHT);

		setFtfObsiegen((JFormattedTextField) beschrifter.beschrifteGemeinsam(lblLetztlichObsiegt = new JLabel(),
				new JFormattedTextField(KostenJPanel.FORMATTER_INT),
				(UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(14005), pnLetztlichObsiegt));
		getFtfObsiegen().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
//		getFtfObsiegen().setHorizontalAlignment(SwingConstants.RIGHT);
//		lblLetztlichObsiegt.setLabelFor(getFtfObsiegen());

		leereTextfelder();

		btnBerechnungsMethode = (JToggleButton) beschrifter.add(berechnungsMethodeAction, this);
		beschrifter.add((BeschriebeneAktion) tenorErmittelnAction, this);

		// btnBerechnungsMethode = berechnungsMethodeAction.toJToggleButton();

//		JButton btnBerechneTeilklageruecknahme = 
//		.toButton();

		// pnParteien.add(lblKlBezeichner,
		// GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1,
		// GridBagConstraints.HORIZONTAL, false));
		// NameContainerSammlung.BESCHRIFTUNGEN.get(11001).gitterBeutel.toGitterBeutel());

//		pnParteien.add(cbKlaeger,
//		beschrifter.testHinein(pnParteien, cbKlaeger,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));

//		beschrifter.testHinein(pnParteien, lblBkBezeichner,
//		pnParteien.add(lblBkBezeichner, 11011
//				GitterBeutelBeschraenkungen.getInstance(2, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// pnParteien.add( 11015
//		beschrifter.testHinein(pnParteien, cbBeklagte,
//				GitterBeutelBeschraenkungen.getInstance(3, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
		// add( 11000
//		beschrifter.testUnVergittert(this, pnParteien, 
//		GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.HORIZONTAL, false));

//		pnVorher.add( 12001
//		beschrifter.testUnVergittert(pnVorher,
//				lblStreitwertVorReduktion,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(pnVorher,
//			pnVorher.add(
//				ftfStreitwertVorher,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(pnVorher,
//				pnVorher.add(
//				scpVorher, GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 1, GridBagConstraints.BOTH, false));
//		beschrifter.testUnVergittert(pnVorher,
//				pnVorher.add(
//				btnNeueGebhrvorher,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 3, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(this,
//		add(
//				pnVorher, GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 2, GridBagConstraints.BOTH, false));
//		pnNachher.add(
//		beschrifter.testUnVergittert(pnNachher,
//				lblStreitwertNachReduktion,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//				pnNachher.add(
//		beschrifter.testUnVergittert(pnNachher,
//				getFtfStreitwertNachher(),
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
//				pnNachher.add(
//		beschrifter.testUnVergittert(pnNachher, scpNachher,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 3, 1, GridBagConstraints.BOTH, false));
//				pnNachher.add(
//		beschrifter.testUnVergittert(pnNachher, btnNeueGebhrnachher,
//				GitterBeutelBeschraenkungen.getInstance(0, 2, 3, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testUnVergittert(this,
//				add(
//				pnNachher, GitterBeutelBeschraenkungen.getInstance(0, 4, 3, 2, GridBagConstraints.BOTH, false));
//		.add(
//		beschrifter.testUnVergittert(pnLetztlichObsiegt, lblLetztlichObsiegt,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//				pnLetztlichObsiegt.add(
//		beschrifter.testUnVergittert(pnLetztlichObsiegt, getFtfObsiegen(),
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 2, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this,
//				pnLetztlichObsiegt,
//				GitterBeutelBeschraenkungen.getInstance(0, 8, 3, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, btnBerechnungsMethode,
//				GitterBeutelBeschraenkungen.getInstance(0, 9, 3, 1, GridBagConstraints.HORIZONTAL, false));
//		add(
//		beschrifter.testUnVergittert(this, btnBerechneTeilklageruecknahme,
//				GitterBeutelBeschraenkungen.getInstance(0, 10, 3, 1, GridBagConstraints.HORIZONTAL, false));

		final PopupMenuBuilder builder = new PopupMenuBuilder();
		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17100), tabVorher, new Integer[] { 1 },
				(BeschriebeneAktion) neueGebuehrVorherAction, (BeschriebeneAktion) klageruecknahmeTerminAction,
				(BeschriebeneAktion) eintragEntfernenAktion, (BeschriebeneAktion) gebuehrenTbVerschiebenAction);

		builder.build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(17200), tabNachher, new Integer[] { 1 },
				(BeschriebeneAktion) neueGebuehrNachherAction, (BeschriebeneAktion) klageruecknahmeTerminAction,
				(BeschriebeneAktion) eintragEntfernenAktion, (BeschriebeneAktion) gebuehrenTbVerschiebenAction);

		logDauer();
	}

	/**
	 * Die Methode leert alle Tabellen und Textfelder der Streitwertreduktion
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	@Override
	public void leereWerte() {
		leereGebuehrenTabellen();// false
		leereTextfelder();
	}

	/**
	 * Die Methode leert alle Tabellen der Streitwertreduktion oder füllt sie mit
	 * den Tatbeständen zum aus dem {@link Teilklageruecknahme}-Behälter. Zudem
	 * füllt sie die {@link JFormattedTextField} mit den Streitwertangaben.
	 * 
	 * @param container ein {@link Teilklageruecknahme} -Behälter
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setzeWerte(Streitgenossen,
	 *      java.lang.Object)
	 */
	@Override
	public void setzeWerte(final Teilklageruecknahme container) {
		cbKlaeger.setSelectedItem(container.parteien.get(0));
		cbBeklagte.setSelectedItem(container.parteien.get(1));
		ftfStreitwertVorher.setText(container.streitwerteUndObsiegen.get(0).toString());
		getFtfStreitwertNachher().setText(container.streitwerteUndObsiegen.get(1).toString());
		getFtfObsiegen().setText(container.streitwerteUndObsiegen.get(2).toString());
		setGttmVorher(new GebuehrenTableModel(container.vorher));
		tabVorher.setModel(getGttmVorher());
		setGttmNachher(new GebuehrenTableModel(container.nachher));
		tabNachher.setModel(getGttmNachher());
		Kostenrechner.getLogger().info("Fertig!");
	}

	/**
	 * Die Methode dient dazu, alle Programmzustände in einen
	 * {@link VerfahrensDatenContainer} zu packen
	 * 
	 * @return den Untercontainer von
	 *         {@link VerfahrensDatenContainer#teilklageruecknahme}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public Teilklageruecknahme baueRueckgabewert() {
		pruefer.leseComponents(cbKlaeger, cbBeklagte, tabVorher, tabNachher, getFormattedTextField(TABLE_FTF_VORHER),
				getFormattedTextField(TABLE_FTF_NACHHER), getFormattedTextField(FTF_OBSIEGEN)).parseEingabe();
		return pruefer.getRueckgabewert();
	}

	/**
	 * Die Methode dient dazu, eine Referenz auf das Hauptfenster zu übermitteln
	 * 
	 * @param kostenrechner
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 */
	@Override
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * Die Methode prüft, ob wenigstens eine der beiden
	 * GebuehrenTatbestandTableModels auf dem Tab für die Teilerledigung/-rücknahme
	 * Daten enhtält.
	 * 
	 * @return true, wenn eine der beiden GebuehrenTatbestandTableModels Daten
	 *         enthält; false, wenn beide leer sind.
	 */
	public boolean pruefeTabellen() {
		return getGttmVorher().getRowCount() > 0 || getGttmNachher().getRowCount() > 0;
	}

	/**
	 * Die Methode gibt ein {@link JFormattedTextField} der Wahl zurück.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER}, {@link #TABLE_FTF_NACHHER}
	 *              oder {@link #FTF_OBSIEGEN}
	 * @return gibt das gewählte {@link JFormattedTextField} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getFormattedTextField(int)
	 */
	@Override
	public JFormattedTextField getFormattedTextField(int index) {
		switch (index) {
		case TABLE_FTF_VORHER:
			return this.ftfStreitwertVorher;
		case TABLE_FTF_NACHHER:
			return this.ftfStreitwertNachher;
		case FTF_OBSIEGEN:
			return this.ftfObsiegen;
		default:
			break;
		}
		return null;
	}

	/**
	 * Die Methode soll den Text des zum {@link JFormattedTextField} gehörenden
	 * {@link JLabel}s zurückgeben.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER}, {@link #TABLE_FTF_NACHHER}
	 *              oder {@link #FTF_OBSIEGEN}
	 * @return das {@link JLabel#getText()} als String
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTextFieldHandler#getLabelText(int)
	 */
	@Override
	public String getLabelText(int index) {
		switch (index) {
		case TABLE_FTF_VORHER:
			return this.lblStreitwertVorReduktion.getText();
		case TABLE_FTF_NACHHER:
			return this.lblStreitwertNachReduktion.getText();
		case FTF_OBSIEGEN:
			return this.lblLetztlichObsiegt.getText();
		default:
			break;
		}
		return null;
	}

	/**
	 * @param ftfStreitwertNachher d. {@link #ftfStreitwertNachher}, d. gesetzt
	 *                             werden soll als JFormattedTextField
	 */
	public void setFtfStreitwertNachher(JFormattedTextField ftfStreitwertNachher) {
		this.ftfStreitwertNachher = ftfStreitwertNachher;
	}

	/**
	 * @param ftfObsiegen d. {@link #ftfObsiegen}, d. gesetzt werden soll als
	 *                    JFormattedTextField
	 */
	public void setFtfObsiegen(JFormattedTextField ftfObsiegen) {
		this.ftfObsiegen = ftfObsiegen;
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

	/**
	 * Die Methode gibt ein {@link GebuehrenTableModel} der Wahl zurück.
	 * 
	 * @param index entweder {@link #TABLE_FTF_VORHER} oder
	 *              {@link #TABLE_FTF_NACHHER}
	 * @return {@link #getGttmVorher()} oder {@link #getGttmNachher()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.PanelTableModelHandler#getTableModel(int)
	 */
	@Override
	public GebuehrenTableModel getTableModel(int index) throws IndexOutOfBoundsException {
		if (index == TABLE_FTF_VORHER) {
			return getGttmVorher();
		} else if (index == TABLE_FTF_NACHHER) {
			return getGttmNachher();
		}
		throw new IndexOutOfBoundsException();
	}

	/**
	 * @param index ein Bezeichner für das {@link TableModel}, also
	 *              {@link TeilklageruecknahmePanel#TAB_VORHER} oder
	 *              {@link TeilklageruecknahmePanel#TAB_NACHHER}
	 * @return den index der ersten ausgewählten Zeile der {@link JTable} oder
	 *         <code>-1</code>, wenn die {@link JTable} <code>null</code> oder keine
	 *         Zeile ausgewählt ist.
	 * @throws IndexOutOfBoundsException wenn ein falscher <code>index</code>
	 *                                   übergeben wird.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler#getSelectedRow(int)
	 */
	@Override
	public int getSelectedRow(int index) {
		if (index == TABLE_FTF_VORHER) {
			if (tabVorher != null)
				return tabVorher.getSelectedRow();
			else
				return -1;
		} else if (index == TABLE_FTF_NACHHER) {
			if (tabNachher != null)
				return tabNachher.getSelectedRow();
			else
				return -1;
		}
		throw new IndexOutOfBoundsException();
	}

	/**
	 * @return gibt {@link #gttmVorher} als GebuehrenTatbestandTableModel zurück.
	 */
	public GebuehrenTableModel getGttmVorher() {
		return gttmVorher;
	}

	/**
	 * @return gibt {@link #gttmNachher} als GebuehrenTatbestandTableModel zurück.
	 */
	public GebuehrenTableModel getGttmNachher() {
		return gttmNachher;
	}

	/**
	 * Die Methode übergibt die gewählte Berechnungsmethode
	 * 
	 * @return
	 */
	public boolean isQuotenMethodeVorziehen() {
		if (btnBerechnungsMethode == null)
			return true;
		return btnBerechnungsMethode.isSelected();
	}

	/**
	 * Die Methode dient dazu, dass eine {@link BeschriebeneAktion} den Focus auf
	 * die {@link JComponent} legen kann, die sie aufruft.
	 * 
	 * @return <code>true</code>, wenn der Aufruf wahrscheinlich Erfolg hat;
	 *         <code>false</code>, wenn er zum Scheitern verurteilt ist.
	 * 
	 * @see javax.swing.JComponent#requestFocusInWindow()
	 */
	@Override
	public boolean requestFocusInWindow() {
		getKostenrechner().getTabbedPane().setSelectedIndex(Teilklageruecknahme.TAB_ID);
		return super.requestFocusInWindow();
	}

	/**
	 * @return gibt {@link #ftfObsiegen} als JFormattedTextField zurück.
	 */
	private JFormattedTextField getFtfObsiegen() {
		return ftfObsiegen;
	}

	/**
	 * @return gibt {@link #ftfStreitwertNachher} als JFormattedTextField zurück.
	 */
	private JFormattedTextField getFtfStreitwertNachher() {
		return ftfStreitwertNachher;
	}

	/**
	 * Die Methode leert alle Textfelder der Streitwertreduktion
	 * 
	 */
	private void leereTextfelder() {
		ftfStreitwertVorher.setText("0");
		getFtfStreitwertNachher().setText("0");
		getFtfObsiegen().setText("0");
	}

	/**
	 * Die Methode leert alle Tabellen der Streitwertreduktion
	 * 
	 */
	private void leereGebuehrenTabellen() {
		setGttmVorher(new GebuehrenTableModel(new GebuehrenAuflistung()));
		setGttmNachher(new GebuehrenTableModel(new GebuehrenAuflistung()));
		if (tabVorher != null)
			tabVorher.setModel(getGttmVorher());
		if (tabNachher != null)
			tabNachher.setModel(getGttmNachher());
	}

	/**
	 * @param gttmNachher d. {@link #gttmNachher}, d. gesetzt werden soll als
	 *                    GebuehrenTatbestandTableModel
	 */
	private void setGttmNachher(GebuehrenTableModel gttmNachher) {
		this.gttmNachher = gttmNachher;
	}

	/**
	 * @param gttmVorher d. {@link #gttmVorher}, d. gesetzt werden soll als
	 *                   GebuehrenTatbestandTableModel
	 */
	private void setGttmVorher(GebuehrenTableModel gttmVorher) {
		this.gttmVorher = gttmVorher;
	}

}
