/**
 * FehlerDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.Color;
import java.awt.FlowLayout;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;

/**
 * Eine Klasse, die Fehlermeldungen ausführlicher darstellt.
 *
 * @author Peter Schuster (setrok)
 * @date 26.08.2014
 *
 */
public class FehlerDialog extends BeschrifteterJDialog {

	private static final long serialVersionUID = 306283812188663774L;
	public static final String FEHLER_BLANKO = "Fehler";
	/**
	 * Das Info-Fenster soll maximal 7 Zeilen enthalten
	 */
	private static final int MAX_ZEILEN_TRACE = 11;
	/**
	 * Die eigentliche Fehlermeldung soll nur zwei Zeilen haben.
	 */
	private static final int FEHLER_ZEILEN = 2;

	private final FehlerHelper feHelper;

	/**
	 * Der Konstruktor initialisiert den Dialog und gibt eine StackTrace aus.
	 * 
	 * @param feHelper  den {@link FehlerHelper}
	 * @param throwable das {@link Throwable} (Oberklasse von {@link Exception}),
	 *                  das geworfen wurde.
	 */
	public FehlerDialog(String meldung, FehlerHelper feHelper) {
		super(Kostenrechner.getInstance(), ((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(72000)));
		this.feHelper = feHelper;
	}

	/**
	 * Die Methode füllt das contentPane mit einem Icon-Label, einer JTextArea für
	 * die eigentliche Meldung und einer JTextArea im JScrollPane für den
	 * StackTrace.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		JPanel meldungPane = new JPanel();
		meldungPane.setLayout(new FlowLayout(FlowLayout.LEFT));
		Border schwarz = BorderFactory
				.createLineBorder(UIManager.getLookAndFeel().getDefaults().getColor("Button.shadow"));
		meldungPane.setBorder(BorderFactory.createTitledBorder(schwarz));
		beschrifter.beschrifteVergittert(meldungPane, NameContainerSammlung.BESCHRIFTUNGEN.get(72100), contentPanel);

		JLabel lblIcon = (JLabel) beschrifter.beschrifte(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(72102));

		JTextArea jtaMeldung = (JTextArea) beschrifter.beschrifte(new JTextArea(feHelper.getMeldung()),
				NameContainerSammlung.BESCHRIFTUNGEN.get(72101));

		// meldung
		jtaMeldung.setRows(FEHLER_ZEILEN);
		jtaMeldung.setEditable(false);
		jtaMeldung.setOpaque(false);
		jtaMeldung.getCaret().setVisible(true);

//		JScrollPane scpStackTrace = baueStackTracePane();

		// new JScrollPane()
		beschrifter.beschrifteVergittert(baueStackTracePane(), NameContainerSammlung.BESCHRIFTUNGEN.get(72200),
				contentPanel);

		meldungPane.add(lblIcon);
		meldungPane.add(jtaMeldung);
		
		toButtonPanel(feHelper.getEmailAktion());
		
//		.add(
//		beschrifter.testUnVergittert(contentPanel, meldungPane,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		contentPanel.add(
//				beschrifter.testUnVergittert(contentPanel,scpStackTrace,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.BOTH, true));

//		getButtonPane().add((feHelper.getEmailAktion()).toButton());
//		addToRootInputMap(feHelper.getEmailAktion());
	}

	/**
	 * Die Methode baut zu debug-Zwecken eine {@link JScrollPane} mit einem über
	 * {@link FehlerHelper#baueFehlerXmlString(boolean)} in XML konvertierten
	 * {@link Throwable#getStackTrace()}.
	 * 
	 * Wenn {@link Kostenrechner#debug} nicht aktiv ist, gibt baut sie nur eine
	 * leere {@link JScrollPane}.
	 * 
	 * @return die {@link JScrollPane}
	 */
	private JScrollPane baueStackTracePane() {
//				(JScrollPane) beschrifter.beschrifteVergittert(new JScrollPane(),
//				NameContainerSammlung.BESCHRIFTUNGEN.get(72200), contentPanel)
		JScrollPane scpStackTrace = new JScrollPane();
		scpStackTrace.setVisible(Kostenrechner.debug);

		// Wenn kein debug, reicht das schon.
		if (!Kostenrechner.debug) {
			return scpStackTrace;
		}

		// Sonst geht es jetzt los
		JTextArea jtaStackTrace = (JTextArea) beschrifter.beschrifte(new JTextArea(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(72201));

		jtaStackTrace.setText(feHelper.baueFehlerXmlString(true));
		jtaStackTrace.setForeground(Color.RED);
		jtaStackTrace.setRows(MAX_ZEILEN_TRACE);
		jtaStackTrace.setCaretPosition(0);
		jtaStackTrace.setEditable(false);
		scpStackTrace.setViewportView(jtaStackTrace);

		return scpStackTrace;
	}

}
