/**
 * HilfePanel.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.HtmlWerkzeugKasten;
import eu.gronos.kostenrechner.view.KostenJPanel;

/**
 * Registerkarte 4 Hilfe
 *
 * @author Peter Schuster (setrok)
 * @date 22.06.2018
 *
 */
public class HilfePanel extends KostenJPanel {

	private static final String KOSTENTENOR_HILFETEXT_HTML = "resources/hilfetext.html";
	public static final int TAB_HILFE = 4;
	private static final long serialVersionUID = 6247368145017378263L;
	private static HilfePanel instance = new HilfePanel();
	private Kostenrechner kostenrechner;

	/**
	 * Konstruktor ist private, weil Singleton.
	 * 
	 * Besonderheit: BorderLayout statt GridBagLayout
	 * 
	 */
	private HilfePanel() {
		super();
		setLayout(new BorderLayout());
	}

	/**
	 * Die Methode setzt die Registerkarte 4 Hilfe mit einem einzigen JScrollPane im
	 * JPanel und darin einen JTextPane mit Hilfetext.
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#buildPanel()
	 */
	@Override
	public void buildPanel() {
		JTextPane textPane = (JTextPane) beschrifter.beschrifte(new JTextPane(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(50011));
		add(beschrifter.beschrifte(new JScrollPane(textPane), NameContainerSammlung.BESCHRIFTUNGEN.get(50010)),
				BorderLayout.CENTER);

		final HtmlWerkzeugKasten kit = new HtmlWerkzeugKasten();
		textPane.setEditorKit(kit);
		kit.read(KOSTENTENOR_HILFETEXT_HTML, textPane);
		textPane.getCaret().setVisible(true);
		logDauer();
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}

	/**
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setKostenrechner(eu.gronos.kostenrechner.Kostenrechner)
	 * 
	 */
	@Override
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * @return gibt {@link #instance} als HilfePanel zurück.
	 */
	public static HilfePanel getInstance() {
		return instance;
	}


}
