/**
 * LizenzAkzeptanzHinzufuegen.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.helpanderror;

import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangVorsorgeBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.MausLogHorcher;
import eu.gronos.kostenrechner.controller.system.GplAnzeigenToggleAction;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ein {@link HinzufuegenDialog}, der beim ersten Programmstart die Annahme der
 * Lizenzbedingungen abwartet.
 *
 * @author Peter Schuster (setrok)
 * @date 03.12.2014
 *
 */
public class LizenzZustimmungDialog extends AkzeptanzDialog<Boolean> {

	private static final String LIZENZ_HTML = "resources/lizenz.html";
	private static final long serialVersionUID = -774138389489802048L;
	private final Action gplAnzeigenAktion = new GplAnzeigenToggleAction(
			(LangVorsorgeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73055), this);

	/**
	 * Konstruktor: erzeugt eine Instanz des {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner ein {@link JFrame}
	 * @throws HeadlessException
	 */
	public LizenzZustimmungDialog(JFrame owner) throws HeadlessException {
		this(owner, true);
	}

	/**
	 * Konstruktor: erzeugt eine Instanz der {@link LizenzZustimmungDialog}.
	 * 
	 * @param owner            ein {@link JFrame}
	 * @param zustimmungNoetig wenn <code>true</code>, dann wird der OK-Button in
	 *                         "Ja, ich stimme zu!" umbenannt.
	 * @throws HeadlessException
	 */
	public LizenzZustimmungDialog(JFrame owner, boolean zustimmungNoetig) throws HeadlessException {
		super(owner, (Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73000));
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		if (zustimmungNoetig) {
			beschrifter.beschrifte(super.getOkButton(), NameContainerSammlung.BESCHRIFTUNGEN.get(73051));
		} else {
			beschrifter.changeTo(((Vorsorgend<?>) super.getBeschriftung()), 1);
			beschrifter.beschrifte(this, super.getBeschriftung());
			infoPanelErgaenzen();
		}
		super.setOkButtonToBeFocussed(true);
	}

	/**
	 * @return {@link Boolean#TRUE} - wenn Ok gedrückt wird, ist alles gut.
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override //
	protected Boolean baueRueckgabewert() {
		return Boolean.TRUE;
	}

	@Override
	protected void fuelleContentPane() {
		baueTextPane(LIZENZ_HTML);
		super.getButtonPane().add(((BeschriebeneAktion) gplAnzeigenAktion).toButton());
	}

	/**
	 * Die Methode ergänzt das {@link BeschrifteterJDialog#contentPanel} um eine Info übers
	 * Programm.
	 */
	private void infoPanelErgaenzen() {
		JPanel infoPanel = new JPanel();
		final GridBagLayout gbl_infoPanel = new GridBagLayout();

		Border schwarz = BorderFactory
				.createLineBorder(UIManager.getLookAndFeel().getDefaults().getColor("Button.shadow"));
		TitledBorder brdr = BorderFactory.createTitledBorder(schwarz);
		infoPanel.setBorder(brdr);
		infoPanel.setLayout(gbl_infoPanel);
		beschrifter.beschrifteVergittert(infoPanel, NameContainerSammlung.BESCHRIFTUNGEN.get(73100), contentPanel);

		UnBeschriftung nameBeschriftung = (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73110);
		JLabel lblName = (JLabel) beschrifter.beschrifteVergittert(new JLabel(), nameBeschriftung, infoPanel);
		lblName.setText(nameBeschriftung.getRef().getTitle());

//		JLabel lblCopy = (JLabel) 
		beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(73120), infoPanel);
		Beschriftung logBeschriftung = (Beschriftung) beschrifter.changeTo(
				(VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(73130), 0,
				Kostenrechner.getLogFileName());
		JLabel lblLog = (JLabel) beschrifter.beschrifteVergittert(new JLabel(), logBeschriftung, infoPanel);
		// Link aufs Logfile ergänzen
		lblLog.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		lblLog.addMouseListener(new MausLogHorcher());

		// Rechnerhammer (BildOhneTitel)
//		JLabel lblBild = (JLabel) 
		beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(73140), infoPanel);

//		.add(
//		beschrifter.testUnVergittert(infoPanel, lblBild,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 3, GridBagConstraints.BOTH, false));
//		infoPanel.add(
//		beschrifter.testUnVergittert(infoPanel, lblName,
//				GitterBeutelBeschraenkungen.getInstance(1, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		infoPanel.add(
//		beschrifter.testUnVergittert(infoPanel, lblCopy,
//				GitterBeutelBeschraenkungen.getInstance(1, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		infoPanel.add(
//		beschrifter.testUnVergittert(infoPanel, lblLog,
//				GitterBeutelBeschraenkungen.getInstance(1, 2, 1, 1, GridBagConstraints.HORIZONTAL, false));

		// .add(
//		beschrifter.testUnVergittert(contentPanel, infoPanel,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.HORIZONTAL, false));
	}
}
