/*
 * BearbeitenJMenu.java
 * eu.gronos.kostenrechner.view.menus (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Das Menü Extras enthält die Aktionen für Menüpunkte, die etwas einfügen, aber
 * nichts mit Dateien machen.
 *
 * @author Peter Schuster (setrok)
 * @date 05.03.2020
 *
 */
public class BearbeitenJMenu extends KostenJMenu {

	private static final long serialVersionUID = -6429659703992784649L;
	private static final BearbeitenJMenu instance = new BearbeitenJMenu();

	/**
	 * Konstruktor
	 * 
	 */
	private BearbeitenJMenu() {
		super();
	}

	/**
	 * Die Methode dient dazu, das Menü zusammenzubauen.
	 * 
	 */
	public void buildMenu() {
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		beschrifter.beschrifte(this, NameContainerSammlung.BESCHRIFTUNGEN.get(64000));

		add(((BeschriebeneAktion) TeilklageruecknahmePanel.getInstance().klageruecknahmeTerminAction).toMenuItem());
		addSeparator();

		add(((BeschriebeneAktion) GebuehrenBerechnungPanel.getInstance().saeumnisGebuehrenAction).toMenuItem());
		add(((BeschriebeneAktion) GebuehrenBerechnungPanel.getInstance().anerkenntnisGebuehrenAction).toMenuItem());
		add(((BeschriebeneAktion) GebuehrenBerechnungPanel.getInstance().normaleGebuehrenAction).toMenuItem());
	}

	/**
	 * @return gibt {@link #instance} als {@link BearbeitenJMenu} zurück.
	 */
	public static BearbeitenJMenu getInstance() {
		return instance;
	}

}
