/**
 * AktionenJMenu.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.model.IntegerConfigSchluessel;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.util.IntegerConfigOption;
import eu.gronos.kostenrechner.controller.system.InfoAction;
import eu.gronos.kostenrechner.controller.system.Paragraph92Action;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailAllgemein;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailXml;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Das Menü Extras enthält die Aktionen für alle möglichen Menüpunkte, die nicht
 * nur etwas einfügen und nichts mit Dateien machen.
 *
 * @author Peter Schuster (setrok)
 * @date 20.06.2018
 *
 */
public class ExtrasJMenu extends KostenJMenu implements WerteLesbar<Allgemein> {

	private static final long serialVersionUID = 7935405681482100256L;
	private static final ExtrasJMenu instance = new ExtrasJMenu();
	private AbstractAction ueberAction = new InfoAction(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62081));
	private final AbstractAction emailSchreibenXML = new SchreibeEmailXml(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62101));
	private final AbstractAction emailSchreibenAllgemein = new SchreibeEmailAllgemein(
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62111));
	public JCheckBoxMenuItem mi92;

	private final SchluesselBeschriftung beschriftungVH92ii = (SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN
			.get(78000);
	private final IntegerConfigOption optionVH92ii = new IntegerConfigOption(
			(IntegerConfigSchluessel) beschriftungVH92ii.getConfigSchluessel());
	private final Paragraph92Action action92ii = new Paragraph92Action(
			(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(62011), beschriftungVH92ii, optionVH92ii);

	private final SchluesselBeschriftung beschriftungAlsBruch = (SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN
			.get(62021);
	private final BooleanConfigAction actionAlsBruch = new BooleanConfigAction(beschriftungAlsBruch);
	private JCheckBoxMenuItem miAlsBruch;

	/**
	 * Der private Konstruktor hat keine Parameter
	 * 
	 */
	private ExtrasJMenu() {
		super();
	}

	/**
	 * Die Methode dient dazu, das Menü Aktionen mit Menüpunkten zu füllen
	 * 
	 */
	public void buildMenu() {
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		beschrifter.beschrifte(this, NameContainerSammlung.BESCHRIFTUNGEN.get(62000));
		mi92 = (JCheckBoxMenuItem) action92ii.toMenuItem();
		add(mi92);

		miAlsBruch = (JCheckBoxMenuItem) actionAlsBruch.toMenuItem();
		add(miAlsBruch);

		addSeparator();

		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().baumbachAssistentAction).toMenuItem());

		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().gesamtschuldnerschaftExtrahierenAction)
				.toMenuItem());
		add(((BeschriebeneAktion) StreitgenossenPanel.getInstance().gesamtschuldnerschaftDwbkExtrahierenAction)
				.toMenuItem());

		addSeparator();
		add(((BeschriebeneAktion) ueberAction).toMenuItem());

		JMenu kontaktMenu = (JMenu) beschrifter.beschrifte(new JMenu(),
				NameContainerSammlung.BESCHRIFTUNGEN.get(62100));
		kontaktMenu.add(((BeschriebeneAktion) emailSchreibenAllgemein).toMenuItem());
		kontaktMenu.add(((BeschriebeneAktion) emailSchreibenXML).toMenuItem());
		add(kontaktMenu);
	}

	/**
	 * @return gibt {@link #instance} als AktionenJMenu zurück.
	 */
	public static ExtrasJMenu getInstance() {
		return instance;
	}

	/**
	 * Die Methode dient dazu, die Oberflächenelemente des Panels mit Werten zu
	 * füllen, hier mit allgemeinen Programmeinstellungen, die nicht vom Container
	 * selbst gesetzt werden.
	 * 
	 * @param container ein {@link Allgemein}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#setzeWerte(Streitgenossen,
	 *      eu.gronos.kostenrechner.controller.UnterContainerKlasse)
	 */
	@Override
	public void setzeWerte(Allgemein container) {
		mi92.setSelected(container.b92ii);
		optionVH92ii.setValue(container.vomHundert92ii);
		miAlsBruch.setSelected(container.alsBruch);
		// selectedPanel kann -1 sein!
		if (container.selectedPanel > -1)
			getKostenrechner().getTabbedPane().setSelectedIndex(container.selectedPanel);
	}

	/**
	 * Die Methode dient dazu, allgemeine Programmeinstellungen, die nicht vom
	 * Container selbst gesetzt werden, in einen Container zu packen.
	 * 
	 * @return eine {@link UnterContainerKlasse}: {@link Allgemein}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#baueRueckgabewert()
	 */
	@Override
	public Allgemein baueRueckgabewert() {
		Allgemein container = new Allgemein();
		container.aktenzeichen = "k.A.";
		container.b92ii = mi92.isSelected();
		container.vomHundert92ii = optionVH92ii.getValue().intValue();
		container.alsBruch = miAlsBruch.isSelected();
		container.selectedPanel = getKostenrechner().getTabbedPane().getSelectedIndex();
		return container;
	}

	/**
	 * Wenn der leereWerte()-Befehl kommt, setzt die Klasse nur {@link #mi92} wieder
	 * auf <code>true</code>.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.WerteLesbar#leereWerte()
	 */
	@Override
	public void leereWerte() {
		mi92.setSelected(true);
	}

	/**
	 * @return gibt {@link #ueberAction} als {@link AbstractAction} zurück.
	 */
	public AbstractAction getUeberAction() {
		return ueberAction;
	}

}
