/*
 * KostenJMenu.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Diese abstrakte Klasse stellt eine verbesserte {@link #add(JMenuItem)}
 * Methode sowie {@link #getKostenrechner()} und
 * {@link #setKostenrechner(Kostenrechner)} zur Verfügung
 *
 * @author Peter Schuster (setrok)
 * @date 31.12.2019
 *
 */
public abstract class KostenJMenu extends JMenu {

	private static final long serialVersionUID = -5599664110463401747L;
	private Kostenrechner kostenrechner;

	/**
	 * Die Methode fügt einen Menüpunkt hinzu und registriert in in der
	 * {@link JComponent#getActionMap()}
	 * 
	 * @param menuItem ein {@link JMenuItem}
	 * @return das hinzugefügte {@link JMenuItem}
	 * 
	 * @see javax.swing.JMenu#add(javax.swing.JMenuItem)
	 */
	@Override
	public JMenuItem add(JMenuItem menuItem) {
		if (getActionMap() != null) {
			Action action = menuItem.getAction();
			if (action != null) {
				Object key = action.getValue(Action.ACTION_COMMAND_KEY);
				if (key != null) {
					getActionMap().put(key, action);
				}
			}
		}
		return super.add(menuItem);
	}

	/**
	 * @param kostenrechner d. {@link #kostenrechner}, d. gesetzt werden soll als
	 *                      Kostenrechner
	 */
	public void setKostenrechner(Kostenrechner kostenrechner) {
		this.kostenrechner = kostenrechner;
	}

	/**
	 * @return gibt {@link #kostenrechner} als Kostenrechner zurück.
	 */
	public Kostenrechner getKostenrechner() {
		return kostenrechner;
	}
}