/*
 * Schwellenwert92Dialog.java
 * eu.gronos.kostenrechner.view.menus (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.menus;

import java.awt.HeadlessException;
import java.awt.Window;

import javax.swing.JLabel;
import javax.swing.JSlider;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * {@link HinzufuegenDialog}, um die Schwelle für § 92 Abs. 2 ZPO zu setzen.
 *
 * @author Peter Schuster (setrok)
 * @date 19.03.2020
 *
 */
public class Schwellenwert92Dialog extends HinzufuegenDialog<Integer> {

	private static final long serialVersionUID = -5688572392157929699L;
	private JSlider slSchwelle;
	private Integer ausgangsWert;

	/**
	 * Konstruktor:
	 * 
	 * @param owner        das aufrufende {@link Window}
	 * @param beschriftung die {@link Beschriftung} für den Dialog selbst
	 * @param ausgangsWert ein {@link Integer} mit Schwellenwert als status quo
	 *                     ante.
	 * @throws HeadlessException
	 */
	public Schwellenwert92Dialog(Window owner, Beschriftung beschriftung, Integer ausgangsWert)
			throws HeadlessException {
		super(owner, beschriftung);
		this.ausgangsWert = ausgangsWert;
	}

	/**
	 * Hier gibt es keine falsche Eingabe, da der {@link JSlider} sich nur im
	 * Gültigkeitsbereich bewegen lässt.
	 * 
	 * @return <code>true</code>
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		return true;
	}

	/**
	 * Die Methode zieht den Rückgabewert als {@link Integer} aus dem
	 * {@link JSlider}
	 * 
	 * @return den {@link Integer} mit dem ausgewählten Schwellenwert
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#baueRueckgabewert()
	 */
	@Override
	protected Integer baueRueckgabewert() {
		if (slSchwelle != null)
			return slSchwelle.getValue();
		else
			return ausgangsWert;
	}

	/**
	 * Die Methode füllt das {@link BeschrifteterJDialog#contentPanel} mit einem
	 * {@link JLabel} und einem {@link JSlider}
	 * 
	 * @see eu.gronos.beschriftungen.view.BeschrifteterJDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
//		JLabel label = new JLabel();
//		beschrifter.beschrifte
//		toContentPanel(label, NameContainerSammlung.BESCHRIFTUNGEN.get(78005));

		slSchwelle = new JSlider(JSlider.HORIZONTAL);
//		beschrifter.beschrifte
		togetherToContentPanel(slSchwelle, (UnBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(78011));
		slSchwelle.setValue(this.ausgangsWert.intValue());

//		label.setLabelFor(slSchwelle);

//		contentPanel.add(label,
//		beschrifter.testeUnVergittert(contentPanel, label,
//				GitterBeutelBeschraenkungen.getInstance(0, 0, 1, 1, GridBagConstraints.HORIZONTAL, false));
//		beschrifter.testeUnVergittert(contentPanel, slSchwelle,
//				GitterBeutelBeschraenkungen.getInstance(0, 1, 1, 1, GridBagConstraints.HORIZONTAL, false));
	}

}
