package eu.gronos.kostenrechner.view.result;

import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;

/**
 * Ein Renderer für verschiedene {@link Number}-Werte, also {@link Fraction},
 * {@link Euro} und {@link Double}.
 * 
 * Ein Renderer, der alle Double-Werte mit zwei Nachkommastellen darstellt.
 *
 * @author Peter Schuster (setrok)
 * @date 20.10.2014
 *
 * 
 */
public class BegruendungsZahlenRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = -6700491875528099319L;
	private final boolean alsBruch;
	private String format;

	/**
	 * Der Konstruktor setzt das Format für Double auf "%,.2f"
	 * 
	 * @param alsBruch der Wert von {@link Allgemein#alsBruch}
	 */
	public BegruendungsZahlenRenderer(final boolean alsBruch) {
//		format = "%,.2f";
		this(alsBruch, "%,.2f");
	}

	/**
	 * @param alsBruch der Wert von {@link Allgemein#alsBruch}
	 * @param format   Der Formatierungs-String für
	 *                 {@link String#format(String, Object...)}, z.B. "%,.2f"
	 */
	public BegruendungsZahlenRenderer(final boolean alsBruch, String format) {
		this.alsBruch = alsBruch;
		this.format = format;
	}

	/**
	 * Sets the <code>String</code> object for the cell being rendered to
	 * <code>value</code>.
	 *
	 * @param value the string value for this cell; if value is <code>null</code> it
	 *              sets the text value to an empty string
	 * @see JLabel#setText
	 *
	 */
	@Override
	protected void setValue(Object value) {
		if (value instanceof Euro) {
			setText(((HtmlRtfFormattierend) value).toHtmlString());
		} else if (value instanceof Fraction) {
			Fraction f = (Fraction) value;
			setText(alsBruch ? f.toHtmlString() : f.toPercentString());
		} else if (value instanceof Number) {
			setText(String.format(format, ((Number) value).doubleValue()));
		} else {
			super.setValue(value);
		}
		setHorizontalAlignment(SwingConstants.RIGHT);
	}

//	private final String format;// = "%,.2f";
//
//	/**
//	 * Konstruktor mit Formatierungsstring
//	 * 
//	 * @param format
//	 *            Der Formatierungs-String für
//	 *            {@link String#format(String, Object...)}, z.B. "%,.2f"
//	 */
//	NachkommastellenRenderer(String format) {
//		super();
//		this.format = format;
//	}
//	
//	/**
//	 * Konstruktor ohne Formatierungsstring, formatiert alles mit "%,.2f"
//	 * 
//	 */
//	public NachkommastellenRenderer() {
//		this("%,.2f");
//	}
//
//	@Override
//	public Component getTableCellRendererComponent(JTable table, Object value,
//			boolean isSelected, boolean hasFocus, int row, int column) {
//		if (value != null)
//			if (value instanceof Double) {
//				setText(String.format(format, value));
//			} else if (value instanceof Number) {
//				final double doubleValue = ((Number) value).doubleValue();
//				setText(String.format(format, doubleValue));
//			} else
//				setText(value.toString());
//		else
//			setText("");
//		setHorizontalAlignment(SwingConstants.RIGHT);
//		setSelected(isSelected);
//		if (table.isPaintingForPrint()) {
//			setText(getText() + "\t ");
//		}
//		return this;
//	}

}
