/**
 * TenorDialog.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.view.result;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.util.PreferencesConfigOption;
import eu.gronos.beschriftungen.view.FontHelfer;
import eu.gronos.beschriftungen.view.FontHelferForWindow;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.TenorBegruendungAction;
import eu.gronos.kostenrechner.controller.files.RtfWerkzeugKasten;
import eu.gronos.kostenrechner.controller.files.RtfZwischenablageAction;
import eu.gronos.kostenrechner.controller.files.SpeichereRtfAction;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailTenorFalsch;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.util.TenorierendAdapter;

/**
 * Ein JDialog, der einen Tenor anzeigt und diesen auf Wunsch als RTF speichert
 * und diesen auch in die Zwischenablage kopieren kann.
 * 
 * @author Peter Schuster (setrok)
 * @date 15.06.2014
 */
public class TenorDialog extends BeschrifteterJDialog {

	private static final long serialVersionUID = -7570808761464484864L;
	// private JScrollPane scpKostentenor;
	JTextPane textPane;
	Tenorierend tenorierend;
	final VerfahrensDatenContainer container;
	private final FontHelferForWindow helper = new FontHelferForWindow(this);
	private final BeschriebeneAktion tenorInZwischenablage = new RtfZwischenablageAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71011));

	private final BeschriebeneAktion tenorSpeichern;
	private final AbstractAction begruendungEinfuegen = new TenorBegruendungAction(this,
			(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71041));
	private BooleanConfigAction liXml = new BooleanConfigAction(
			(SchluesselBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71051));
	private final BeschriebeneAktion emailSchreibenTenorFalsch;

	/**
	 * bereitsGruendeDa speichert, ob die Begründung bereits eingefügt wurde, als
	 * boolean
	 */
	private boolean bereitsGruendeDa = false;
	private final RtfWerkzeugKasten kit;// = new RtfWerkzeugKasten();

	/**
	 * Der Konstruktor verwendet statt eines {@link Tenorierend} jetzt einen
	 * {@link TenorDatenContainer}.
	 * 
	 * @param owner               der JFrame, der den JDialog aufruft
	 * @param tenorDatenContainer der {@link TenorDatenContainer} mit den Daten für
	 *                            den Tenor
	 * @param container           ein VerfahrensDatenContainer
	 */
	public TenorDialog(JFrame owner, TenorDatenContainer container) {
		super(owner,
				((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71000)).setTitle(container.berechnungsTyp));
		this.tenorierend = new TenorierendAdapter(container);
		this.container = container;
		kit = new RtfWerkzeugKasten(container.allgemein.alsBruch);
		emailSchreibenTenorFalsch = new SchreibeEmailTenorFalsch(
				(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71031), container);

		tenorSpeichern = new SpeichereRtfAction(this, container,
				(LangBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71021));
	}

	/**
	 * Die Methode dient dazu, an den Tenortext Gründe anzuhängen, falls es sich
	 * beim {@link #tenorierend} um ein {@link Begruendend} handelt und die Gründe
	 * nicht bereits angehängt wurden.
	 * 
	 */
	public void setBegruendungText() {
		if (!bereitsGruendeDa) {
			final String gruende = tenorierend.getGruende();
			try {

				int caret = textPane.getCaretPosition();
				String gruendeUeberschrift = TenorTexter.GRUENDE_UEBERSCHRIFT;
				if (container.allgemein.selectedPanel == GebuehrenBerechnung.TAB_ID)
					gruendeUeberschrift = TenorTexter.GRUENDE_UEBERSCHRIFT_IM_EINZELNEN;

				kit.insertString(gruende, tenorierend, textPane.getPreferredSize(), gruendeUeberschrift);
						//,container.allgemein.alsBruch
				Kostenrechner.getLogger().info(String.format("caret: %04d; ", caret));
				textPane.setCaretPosition(caret);
				caretVisible(textPane);
				bereitsGruendeDa = true;

				// ist hier, damit die Action auch dann nicht mehr enabled ist, wenn die Methode
				// automatisch aufgerufen wird
				begruendungEinfuegen.setEnabled(false);
			} catch (BadLocationException ble) {
				FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
			}
		}
	}

	/**
	 * @return gibt {@link #docHelper} als {@link RtfDocHelper} zurück.
	 */
	public RtfWerkzeugKasten getKit() {
		return kit;
	}

	/**
	 * Die Methode dient dazu, {@link SpeichereRtfAction} mitzuteilen, ob
	 * strukturierte Tenordaten zusätzlich zu der RTF-Datei gespeichert werden
	 * sollen. soll {@link Kostenrechner#debug} durch
	 * {@link PreferencesConfigOption} ersetzen.
	 * 
	 * @return true, wenn {@link JCheckBoxMenuItem#isSelected()}
	 */
	public boolean isXmlSelected() {
		if (liXml != null)
			return liXml.getValue();
		else
			return false;
	}

	/**
	 * Die Methode fuellt das ContentPane mit einer {@link JTextPane} für den
	 * Tenortext des {@link Begruendend} in einer {@link JScrollPane}. Zudem setzt
	 * sie ein paar mehr {@link JButton Schaltflächen}
	 * 
	 * 
	 * @see eu.gronos.kostenrechner.view.HinzufuegenDialog#fuelleContentPane()
	 */
	@Override
	protected void fuelleContentPane() {
		textPane = (JTextPane) beschrifter.beschrifte(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(71111));
		textPane.setEditorKit(getKit());
		caretVisible(textPane);// textPane.getCaret().setVisible(true);

//		scpKostentenor = (JScrollPane) beschrifter.beschrifteVergittert,contentPanel
		toContentPanel(new JScrollPane(textPane), NameContainerSammlung.BESCHRIFTUNGEN.get(71110));
//		beschrifter.testUnVergittert(contentPanel,
//		.add(
//				scpKostentenor, GitterBeutelBeschraenkungen.getInstance(0, 0, 3, 1, GridBagConstraints.BOTH, true));

		toButtonPanel(tenorInZwischenablage);
		toButtonPanel(tenorSpeichern);
		toButtonPanel(emailSchreibenTenorFalsch);
//		getButtonPane().add(((BeschriebeneAktion) tenorInZwischenablage).toButton()
//		addToRootInputMap();
//		getButtonPane().add(((BeschriebeneAktion) ).toButton());
//		addToRootInputMap(tenorSpeichern);
//		getButtonPane().add(((BeschriebeneAktion) ).toButton());
//		addToRootInputMap(emailSchreibenTenorFalsch);

		DefaultStyledDocument doc = setKostentenorText();
		helper.setPreferredSizeFromAttributeSet(doc.getStyle("base"), FontHelfer.MAX_SPALTEN, FontHelfer.MAX_ZEILEN);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		new PopupMenuBuilder().build((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(71050), textPane,
				new Integer[] { 1 }, (BeschriebeneAktion) tenorSpeichern, liXml,
				(BeschriebeneAktion) tenorInZwischenablage, (BeschriebeneAktion) begruendungEinfuegen);
		/*
		 * Das Einfügen von Begründungen geht nur bei Klassen, die UrteilsTenorierend
		 * implementieren; sonst fehlt die entsprechende Methode
		 */
		begruendungEinfuegen.setEnabled(true);
		// Gründe bei Gebührenberechnung automatisch einfügen
		if (container.allgemein.selectedPanel == GebuehrenBerechnung.TAB_ID) {
			SwingUtilities.invokeLater(() -> setBegruendungText());
		}
	}

	/**
	 * Die Methode setKostentenorText dient dazu, den Tenor der übergegebenen
	 * Tenorklasse im JTextPane mit der passenden Schriftart und Formatierungen zu
	 * setzen. Als Dialogtitel wird die Tenorbeschreibung des Tenorierend gesetzt.
	 * 
	 * @param tenorierend die Tenor erzeugende Klasseninstanz, die "Tenorierend"
	 *                    implementiert.
	 * 
	 * @see javax.swing.text.Document#insertString(int,String,AttributeSet)
	 */
	private DefaultStyledDocument setKostentenorText() {
		final String tenor = tenorierend.erzeugeTenor();
		DefaultStyledDocument doc = kit.getDefaultStyledDocument();
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				try {
					// Beschreibung vom "Tenorierend" holen
					kit.insertString(tenor, tenorierend.getTenorBeschreibung(),
							(tenorierend.getGruende() == null || tenorierend.getGruende().isEmpty()));
					caretVisible(textPane);
				} catch (BadLocationException ble) {
					FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
					// return null;
				}
			}
		});
		return doc;
	}

}
